% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rn_tDensity.R
\docType{class}
\name{Rn_tDensity-class}
\alias{Rn_tDensity-class}
\alias{Rn_tDensity}
\title{An S4 class to represent the function \eqn{\frac{\Gamma\left[(\nu+n)/2\right]}{\Gamma(\nu/2)\nu^{n/2}\pi^{n/2}\left|{\Sigma}\right|^{1/2}}\left[1+\frac{1}{\nu}({\vec{x}}-{\vec{\delta}})^{T}{\Sigma}^{-1}({\vec{x}}-{\vec{\delta}})\right]^{-(\nu+n)/2}} on \eqn{R^n}}
\description{
Implementation of the function
\deqn{f \colon R^n \to (0,\infty),\, \vec{x} \mapsto f(\vec{x}) = \frac{\Gamma\left[(\nu+n)/2\right]}{\Gamma(\nu/2)\nu^{n/2}\pi^{n/2}\left|{\Sigma}\right|^{1/2}}\left[1+\frac{1}{\nu}({\vec{x}}-{\vec{\delta}})^{T}{\Sigma}^{-1}({\vec{x}}-{\vec{\delta}})\right]^{-(\nu+n)/2},}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{R^n = \times_{i=1}^n R}.
In this case the integral is know to be
\deqn{\int_{R^n} f(\vec{x}) d\vec{x} = 1.}
}
\details{
The instance needs to be created with four parameters representing the dimension \eqn{n}, the location vector \eqn{\vec{\delta}}, the variance-covariance matrix \eqn{\Sigma} which needs to be symmetric positive definite and the degrees of freedom parameter \eqn{\nu}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{delta}}{A vector of size dim with real entries.}

\item{\code{sigma}}{A matrix of size dim x dim that is symmetric positive definite.}

\item{\code{df}}{A positive numerical value representing the degrees of freedom.}
}}

\examples{
n <- as.integer(3)
f <- new("Rn_tDensity",dim=n,delta=rep(0,n),sigma=diag(n),df=3)
}
\author{
Klaus Herrmann
}
