% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domainChecks.R
\name{checkPos}
\alias{checkPos}
\title{Domain check for \eqn{[0,\infty)^n }}
\usage{
checkPos(x)
}
\arguments{
\item{x}{Matrix with numeric entries. Each row represents one point}
}
\value{
Vector where each element (TRUE or FALSE) indicates if a point is in \eqn{[0,\infty)^n}
}
\description{
The function checks if a point (one row in the input argument) is inside \eqn{[0,\infty)^n = \times_{i=1}^n [0,\infty)} or not.
In this case the return values are all TRUE.
If the input matrix contains entries that are not numeric, i.e., not representing real numbers, the function throws an error.
The dimension \eqn{n} is automatically inferred from the input matrix and is equal to the number of columns.
}
\examples{
x <- matrix(rexp(30,rate=1),10,3)
checkPos(x)
}
\author{
Klaus Herrmann
}
