% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitBall_polynomial.R
\docType{class}
\name{unitBall_polynomial-class}
\alias{unitBall_polynomial-class}
\alias{unitBall_polynomial}
\title{An S4 class to represent the function \eqn{\prod_{i=1}^n x_i^{a_i}} on \eqn{B_n}}
\description{
Implementation of the function
\deqn{f \colon B_n \to R,\, \vec{x} \mapsto f(\vec{x}) = \prod_{i=1}^n x_i^{a_i},}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{B_n = \{\vec{x}\in R^n : \Vert \vec{x} \Vert_2 \leq 1\}} and \eqn{a_i \in \{0,1,2,3,\ldots\}}, \eqn{i=1,\ldots,n}, are parameters.
If at least one of the coefficients \eqn{a_i} is odd, i.e., \eqn{a_i\in\{1,3,5,7,\ldots\}} for at leas one \eqn{i=1,\ldots,n}, the integral is zero, otherwise the integral is known to be
\deqn{\int_{B_n} f(\vec{x}) d\vec{x} = 2\frac{\prod_{i=1}^n\Gamma(b_i)}{\Gamma(\sum_{i=1}^n b_i)(n+\sum_{i=1}^n a_i)},}
where \eqn{b_i = (a_i+1)/2}.
}
\details{
The instance needs to be created with two parameters representing the dimension \eqn{n} and a \eqn{n}-dimensional vector of integers (including \eqn{0}) representing the exponents.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{expo}}{An vector that captures the exponents}
}}

\examples{
n <- as.integer(3)
f <- new("unitBall_polynomial",dim=n,expo=c(1,2,3))
}
\author{
Klaus Herrmann
}
