% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popls.R
\name{popls}
\alias{popls}
\title{Parallel and Orthogonalised Partial Least Squares - PO-PLS}
\usage{
popls(
  X,
  Y,
  commons = 2,
  auto = TRUE,
  auto.par = list(explVarLim = 40, rLim = 0.8),
  manual.par = list(ncomp = rep(0, length(X)), ncommon = list())
)
}
\arguments{
\item{X}{\code{list} of input blocks}

\item{Y}{\code{matrix} of response variable(s)}

\item{commons}{\code{numeric} giving the highest number of blocks to combine when calculating local or common scores.}

\item{auto}{\code{logical} indicating if automatic choice of complexities should be used.}

\item{auto.par}{\code{named list} setting limits for automatic choice of complexities.}

\item{manual.par}{\code{named list} for manual choice of blocks. The list consists of \code{ncomp} which indicates the number of components to extract from each block and \code{ncommon} which is the corresponding for choosing the block combinations (local/common). For the latter, use unique_combos(n_blocks, commons) to see order of local/common blocks. Component numbers will be reduced if simpler models give better predictions. See example.}
}
\value{
A \code{multiblock} object with block-wise, local and common loadings and scores. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a basic implementation of PO-PLS with manual and automatic component selections.
}
\details{
PO-PLS decomposes a set of input data blocks into common, local and distinct components
through a process involving \code{\link{pls}} and \code{\link{gca}}.
}
\examples{
data(potato)

# Automatic analysis
pot.po.auto <- popls(potato[1:3], potato[['Sensory']][,1])
pot.po.auto$explVar

# Manual choice of up to 5 components for each block and 1, 0, and 2 blocks,
# respectively from the (1,2), (1,3) and (2,3) combinations of blocks.
pot.po.man <- popls(potato[1:3], potato[['Sensory']][,1], auto=FALSE, 
                manual.par = list(ncomp=c(5,5,5), ncommon=c(1,0,2)))
pot.po.man$explVar

# Score plot for local (2,3) components
plot(scores(pot.po.man,3), comps=1:2, labels="names")

}
\references{
\itemize{
\item I Måge, BH Mevik, T Næs. (2008). Regression models with process variables and parallel blocks of raw material measurements. Journal of Chemometrics: A Journal of the Chemometrics Society 22 (8), 443-456
\item I Måge, E Menichelli, T Næs (2012). Preference mapping by PO-PLS: Separating common and unique information in several data blocks. Food quality and preference 24 (1), 8-16
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
