% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpls_results.R
\name{lpls_results}
\alias{lpls_results}
\alias{plot.lpls}
\alias{predict.lpls}
\alias{lplsCV}
\title{Result functions for L-PLS objects (\code{lpls})}
\usage{
\method{plot}{lpls}(
  x,
  comps = c(1, 2),
  doplot = c(TRUE, TRUE, TRUE),
  level = c(2, 2, 2),
  arrow = c(1, 0, 1),
  xlim = c(-1, 1),
  ylim = c(-1, 1),
  samplecol = 4,
  pathcol = 2,
  varcol = "grey70",
  varsize = 1,
  sampleindex = 1:dim(x$corloadings$R22)[1],
  pathindex = 1:dim(x$corloadings$R3)[1],
  varindex = 1:dim(x$corloadings$R21)[1],
  ...
)

\method{predict}{lpls}(
  object,
  X1new = NULL,
  X2new = NULL,
  X3new = NULL,
  exo.direction = c("X2", "X3"),
  ...
)

lplsCV(object, segments1 = NULL, segments2 = NULL, trace = TRUE)
}
\arguments{
\item{x}{\code{lpls} object}

\item{comps}{\code{integer} vector of components.}

\item{doplot}{\code{logical} indicating if plotting should be performed.}

\item{level}{\code{integer} vector of length 3 for selecting plot symbol. 1=dots. 2=dimnames.}

\item{arrow}{\code{integer} vector of length 3 indicating arrows (1) or not (0).}

\item{xlim}{\code{numeric} x limits.}

\item{ylim}{\code{numeric} y limits.}

\item{samplecol}{\code{character} for sample colours.}

\item{pathcol}{\code{character} for third colour.}

\item{varcol}{\code{character} for variable colours.}

\item{varsize}{\code{numeric} size of symbols for variables.}

\item{sampleindex}{\code{integer} for selecting samples.}

\item{pathindex}{\code{integer} for selecting in third direction.}

\item{varindex}{\code{integer} for selecting variables.}

\item{...}{Not implemented.}

\item{object}{\code{lpls} object.}

\item{X1new}{\code{matrix} of new X1 samples.}

\item{X2new}{\code{matrix} of new X2 samples.}

\item{X3new}{\code{matrix} of new X3 samples.}

\item{exo.direction}{\code{character} selecting "X2" or "X3" prediction.}

\item{segments1}{\code{list} of sample segments.}

\item{segments2}{\code{list} of variable segments.}

\item{trace}{\code{logical} indicating if verbose mode should be selected.}
}
\value{
Nothing is return for plotting (\code{plot.lpls}), predicted values are returned for predictions (\code{predict.lpls})
and cross-validation metrics are returned for for cross-validation (\code{lplsCV}).
}
\description{
Correlation loading plot, prediction and cross-validation for L-PLS
models with class \code{\link{lpls}}.
}
\examples{
# Simulate data set
sim <- lplsData(I = 30, N = 20, J = 5, K = 6, ncomp = 2)
X1  <- sim$X1; X2 <- sim$X2; X3 <- sim$X3

# exo-L-PLS:
lp.exo  <- lpls(X1,X2,X3, ncomp = 2)
# Predict X1
pred.exo.X2 <- predict(lp.exo, X1new = X1, exo.direction = "X2")
# Predict X3
pred.exo.X2 <- predict(lp.exo, X1new = X1, exo.direction = "X3")

# endo-L-PLS:
lp.endo <- lpls(X1,X2,X3, ncomp = 2, type = "endo")
# Predict X1 from X2 and X3 (in this case fitted values):
pred.endo.X1 <- predict(lp.endo, X2new = X2, X3new = X3)

# LOO cross-validation horizontally
lp.cv1 <- lplsCV(lp.exo, segments1 = as.list(1:dim(X1)[1]))

# LOO cross-validation vertically
lp.cv2 <- lplsCV(lp.exo, segments2 = as.list(1:dim(X1)[2]))

# Three-fold CV, horizontal
lp.cv3 <- lplsCV(lp.exo, segments1 = as.list(1:10, 11:20, 21:30))

}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
