% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D_regularized_out.R
\name{D_regularized_out}
\alias{D_regularized_out}
\title{Use separate data partition for regularization and estimation.}
\usage{
D_regularized_out(
  data,
  mv.vars,
  group.var,
  group.values,
  alpha = 0.5,
  nfolds = 10,
  s = "lambda.min",
  type.measure = "deviance",
  rename.output = TRUE,
  size = NULL,
  pcc = FALSE,
  auc = FALSE,
  pred.prob = FALSE,
  prob.cutoffs = seq(from = 0, to = 1, by = 0.2),
  append.data = FALSE
)
}
\arguments{
\item{data}{A data frame or list containing two data frames (regularization and estimation data, in that order).}

\item{mv.vars}{Character vector. Variable names in the multivariate variable set.}

\item{group.var}{The name of the group variable.}

\item{group.values}{Vector of length 2, group values (e.g. c("male", "female) or c(0,1)).}

\item{alpha}{Alpha-value for penalizing function ranging from 0 to 1: 0 = ridge regression, 1 = lasso, 0.5 = elastic net (default).}

\item{nfolds}{Number of folds used for obtaining lambda (range from 3 to n-1, default 10).}

\item{s}{Which lambda value is used for predicted values? Either "lambda.min" (default) or "lambda.1se".}

\item{type.measure}{Which measure is used during cross-validation. Default "deviance".}

\item{rename.output}{Logical. Should the output values be renamed according to the group.values? Default TRUE.}

\item{size}{Integer. Size of regularization data per each group. Default 1/4 of cases.}

\item{pcc}{Logical. Include probabilities of correct classification? Default FALSE.}

\item{auc}{Logical. Include area under the receiver operating characteristics? Default FALSE.}

\item{pred.prob}{Logical. Include table of predicted probabilities? Default FALSE.}

\item{prob.cutoffs}{Vector. Cutoffs for table of predicted probabilities. Default seq(0,1,0.20).}

\item{append.data}{Logical. If TRUE, the testing data split is appended to the predicted variables.}
}
\value{
\item{D}{Multivariate descriptive statistics and differences.}
\item{pred.dat}{A data.frame with predicted values.}
\item{cv.mod}{Regularized regression model from cv.glmnet.}
\item{P.table}{Table of predicted probabilities by cutoffs.}
}
\description{
Use separate data partition for regularization and estimation.
}
\examples{
D_regularized_out(
  data = iris[iris$Species == "setosa" |
    iris$Species == "versicolor", ],
  mv.vars = c(
    "Sepal.Length", "Sepal.Width",
    "Petal.Length", "Petal.Width"
  ),
  group.var = "Species",
  group.values = c("setosa", "versicolor"),
  size = 40,
  pcc = TRUE
)$D
}
