% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{residualDiagnostics.lme}
\alias{residualDiagnostics.lme}
\title{residualDiagnostics methods for lme objects}
\usage{
\method{residualDiagnostics}{lme}(
  object,
  ev.perc = 0.001,
  robust = FALSE,
  distr = "normal",
  standardized = TRUE,
  cut = 8L,
  quantiles = TRUE,
  ...
)
}
\arguments{
\item{object}{An object with class \code{lme}.}

\item{ev.perc}{The extreme value percentile to use. Defaults to
.001.}

\item{robust}{A logical value, whether to use robust estimates or not.
Defaults to \code{FALSE}.}

\item{distr}{A character string specifying the assumed distribution.
Currently \dQuote{normal}, but future options may be supported in the
future.}

\item{standardized}{A logical value whether to use standardized pearson
residual values or not. Defaults to \code{TRUE}.}

\item{cut}{An integer, how many unique predicted values
there have to be at least for predicted values to be
treated continuously, otherwise they are treated as discrete values.
Defaults to 8.}

\item{quantiles}{A logical whether to calculate quantiles for the
residuals.  Defaults to \code{TRUE}. If \code{FALSE}, then
do not calculate them. These are based on simple quantiles for
each predicted value if the predicted values are few enough to be
treated discretely. See \code{cut} argument. Otherwise they are
based on quantile regression. First trying smoothing splines,
and falling back to linear quantil regression if the splines
fail. You may also want to turn these off if they are not working well,
or are not of value in your diagnostics.}

\item{...}{Additional arguments. Not currently used.}
}
\value{
A logical (\code{\link[JWileymisc]{is.residualDiagnostics}}) or
  a residualDiagnostics object (list) for
  \code{\link[JWileymisc]{as.residualDiagnostics}} and 
  \code{\link[JWileymisc]{residualDiagnostics}}.
}
\description{
residualDiagnostics methods for lme objects
}
\examples{

library(JWileymisc)
sleep[1,1] <- NA
m <- nlme::lme(extra ~ group, data = sleep, random = ~ 1 | ID,
  na.action = na.omit)

 residualDiagnostics(m)$Residuals

m <- nlme::lme(hp ~ mpg, data = mtcars, random = ~ 1 | cyl,
  na.action = na.omit)
residualDiagnostics(m)$Residuals

rm(m, sleep)
}
