% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submargins.R
\name{submargins}
\alias{submargins}
\title{Average Marginal Substitution}
\usage{
submargins(
  object,
  delta,
  basesub,
  ref = "clustermean",
  level = "total",
  weight = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \code{\link{brmcoda}} object.}

\item{delta}{A integer, numeric value or vector indicating the amount of substituted change between compositional parts.}

\item{basesub}{A \code{data.frame} or \code{data.table} of the base possible substitution of compositional parts.
This data set can be computed using function \code{\link{basesub}}.
If \code{NULL}, all possible pairwise substitution of compositional parts are used.}

\item{ref}{Either a character value or vector or a dataset.
Can be \code{"grandmean"} and/or \code{"clustermean"}, or
a \code{data.frame} or \code{data.table} of user's specified reference grid consisting
of combinations of covariates over which predictions are made.
User's specified reference grid is only possible for simple substitution.}

\item{level}{A character string or vector.
Should the estimate be at the \code{"between"} and/or \code{"within"} level?}

\item{weight}{A character value specifying the weight to use in calculation of the reference composition.
If \code{"equal"}, give equal weight to units (e.g., individuals).
If \code{"proportional"}, weights in proportion to the frequencies of units being averaged
(e.g., observations across individuals)
Default is \code{equal}.}

\item{...}{Additional arguments passed to \code{\link{describe_posterior}}.}
}
\value{
A list containing the results of multilevel compositional substitution model.
The first four lists contain the results of the substitution estimation for a compositional part.
\item{\code{Mean}}{ Posterior means.}
\item{\code{CI_low} and \code{CI_high}}{ 95\% credible intervals.}
\item{\code{Delta}}{ Amount substituted across compositional parts.}
\item{\code{From}}{ Compositional part that is substituted from.}
\item{\code{To}}{ Compositional parts that is substituted to.}
\item{\code{Level}}{ Level where changes in composition takes place. Either \code{between} or \code{within}.}
\item{\code{Reference}}{ Either \code{grandmean}, \code{clustermean}, or \code{users}.}
}
\description{
This function is an alias of \code{\link{substitution}} to estimates the the difference in an outcome
when compositional parts are substituted for specific unit(s)
using cluster mean (e.g., compositional mean at individual level) as reference composition.
}
\seealso{
\code{\link{substitution}}
}
