% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data-class.R
\name{nma_data-class}
\alias{nma_data-class}
\alias{nma_data}
\alias{mlnmr_data}
\alias{mlnmr_data-class}
\title{The nma_data class}
\description{
The \code{nma_data} class contains the data for a NMA in a standard format,
created using the functions \code{\link[=set_ipd]{set_ipd()}}, \code{\link[=set_agd_arm]{set_agd_arm()}},
\code{\link[=set_agd_contrast]{set_agd_contrast()}}, or \code{\link[=combine_network]{combine_network()}}. The sub-class \code{mlnmr_data} is
created by the function \code{\link[=add_integration]{add_integration()}}, and further contains numerical
integration points for the aggregate data.
}
\details{
Objects of class \code{nma_data} have the following components:
\describe{
\item{\code{agd_arm}}{data from studies with aggregate data (arm format)}
\item{\code{agd_contrast}}{data from studies with aggregate data (contrast
format)}
\item{\code{ipd}}{data from studies with individual patient data}
\item{\code{treatments}}{treatment coding factor for entire network}
\item{\code{classes}}{treatment class coding factor (same length as \code{treatments}
for entire network)}
\item{\code{studies}}{study coding factor for entire network}
\item{\code{outcome}}{outcome type for each data source, named list}
}

The \code{agd_arm}, \code{agd_contrast}, and \code{ipd} components are
tibbles with the following columns:
\describe{
\item{\code{.study}}{study (as factor)}
\item{\code{.trt}}{treatment (as factor)}
\item{\code{.trtclass}}{treatment class (as factor), if specified}
\item{\code{.y}}{continuous outcome}
\item{\code{.se}}{standard error (continuous)}
\item{\code{.r}}{event count (discrete)}
\item{\code{.n}}{event count denominator (discrete, \code{agd_arm} only)}
\item{\code{.E}}{time at risk (discrete)}
\item{\code{.surv}}{event/censoring time, of type \code{Surv} (time-to-event)}
\item{\code{.sample_size}}{sample size (\verb{agd_*} only)}
\item{\code{...}}{other columns (typically covariates) from the original data
frame}
}

Objects of class \code{mlnmr_data} additionally have components:
\describe{
\item{\code{n_int}}{number of numerical integration points}
\item{\code{int_names}}{names of covariates with numerical integration points}
\item{\code{int_cor}}{correlation matrix for covariates used to generate
numerical integration points}
}

The \code{agd_arm} and \code{agd_contrast} tibbles have additional list columns with
prefix \code{.int_}, one for each covariate, which contain the numerical
integration points nested as length-\code{n_int} vectors within each row.
}
\seealso{
\code{\link[=print.nma_data]{print.nma_data()}} for the print method displaying details of the
network, and \code{\link[=plot.nma_data]{plot.nma_data()}} for network plots.
}
