# Generated by vignette example_thrombolytics.Rmd: do not edit by hand
# Instead edit example_thrombolytics.Rmd and then run precompile.R

skip_on_cran()


params <-
list(run_tests = FALSE)

## ---- code=readLines("children/knitr_setup.R"), include=FALSE-------------------------------------


## ---- eval = FALSE--------------------------------------------------------------------------------
## library(multinma)
## options(mc.cores = parallel::detectCores())

## ----setup, echo = FALSE--------------------------------------------------------------------------
library(multinma)
nc <- switch(tolower(Sys.getenv("_R_CHECK_LIMIT_CORES_")), 
             "true" =, "warn" = 2, 
             parallel::detectCores())
options(mc.cores = nc)


## -------------------------------------------------------------------------------------------------
head(thrombolytics)


## -------------------------------------------------------------------------------------------------
thrombo_net <- set_agd_arm(thrombolytics, 
                           study = studyn,
                           trt = trtc,
                           r = r, 
                           n = n)
thrombo_net


## ---- eval=FALSE----------------------------------------------------------------------------------
## plot(thrombo_net, weight_edges = TRUE, weight_nodes = TRUE)

## ----thrombo_net_plot, echo=FALSE-----------------------------------------------------------------
plot(thrombo_net, weight_edges = TRUE, weight_nodes = TRUE) + ggplot2::theme(legend.margin = ggplot2::margin(l = 4, unit = "lines"))


## -------------------------------------------------------------------------------------------------
summary(normal(scale = 100))


## -------------------------------------------------------------------------------------------------
thrombo_fit <- nma(thrombo_net, 
                   trt_effects = "fixed",
                   prior_intercept = normal(scale = 100),
                   prior_trt = normal(scale = 100))


## -------------------------------------------------------------------------------------------------
thrombo_fit


## ---- eval=FALSE----------------------------------------------------------------------------------
## # Not run
## print(thrombo_fit, pars = c("d", "mu"))


## ----thrombo_pp_plot------------------------------------------------------------------------------
plot_prior_posterior(thrombo_fit, prior = "trt")


## -------------------------------------------------------------------------------------------------
(dic_consistency <- dic(thrombo_fit))


## ----thrombo_resdev_plot, fig.width=12------------------------------------------------------------
plot(dic_consistency)


## -------------------------------------------------------------------------------------------------
thrombo_fit_ume <- nma(thrombo_net, 
                  consistency = "ume",
                  trt_effects = "fixed",
                  prior_intercept = normal(scale = 100),
                  prior_trt = normal(scale = 100))
thrombo_fit_ume


## -------------------------------------------------------------------------------------------------
dic_consistency
(dic_ume <- dic(thrombo_fit_ume))


## ----thrombo_devdev_plot--------------------------------------------------------------------------
plot(dic_consistency, dic_ume, show_uncertainty = FALSE)


## ----thrombo_releff-------------------------------------------------------------------------------
(thrombo_releff <- relative_effects(thrombo_fit, all_contrasts = TRUE))
plot(thrombo_releff, ref_line = 0)


## ----thrombo_ranks--------------------------------------------------------------------------------
(thrombo_ranks <- posterior_ranks(thrombo_fit))
plot(thrombo_ranks)

## ----thrombo_rankprobs----------------------------------------------------------------------------
(thrombo_rankprobs <- posterior_rank_probs(thrombo_fit))
plot(thrombo_rankprobs)

## ----thrombo_cumrankprobs-------------------------------------------------------------------------
(thrombo_cumrankprobs <- posterior_rank_probs(thrombo_fit, cumulative = TRUE))
plot(thrombo_cumrankprobs)


## ----thrombo_tests, include=FALSE, eval=params$run_tests------------------------------------------
#--- Test against TSD 4 results ---
library(testthat)
library(dplyr)

test_that("Reference trt is SK", {
  expect_equivalent(levels(thrombo_net$treatments)[1], "SK")
})

tol <- 0.05
tol_dic <- 0.1

# Relative effects
tsd_releff <- tribble(
~trt_b    , ~trt       , ~mean , ~sd  , ~lower, ~upper,
"SK"      , "t-PA"     , 0.002 , 0.030, -0.06 , 0.06  ,
"SK"      , "Acc t-PA" , -0.177, 0.043, -0.26 , -0.09 ,
"SK"      , "SK + t-PA", -0.049, 0.046, -0.14 , 0.04  ,
"SK"      , "r-PA"     , -0.124, 0.060, -0.24 , -0.01 ,
"SK"      , "PTCA"     , -0.476, 0.101, -0.67 , -0.28 ,
"SK"      , "UK"       , -0.203, 0.221, -0.64 , 0.23  ,
"SK"      , "ASPAC"    , 0.016 , 0.037, -0.06 , 0.09  ,
"t-PA"    , "PTCA"     , -0.478, 0.104, -0.68 , -0.27 ,
"t-PA"    , "UK"       , -0.206, 0.221, -0.64 , 0.23  ,
"t-PA"    , "ASPAC"    , 0.013 , 0.037, -0.06 , 0.09  ,
"Acc t-PA", "r-PA"     , 0.054 , 0.055, -0.05 , 0.16  ,
"Acc t-PA", "TNK"      , 0.005 , 0.064, -0.12 , 0.13  ,
"Acc t-PA", "PTCA"     , -0.298, 0.098, -0.49 , -0.11 ,
"Acc t-PA", "UK"       , -0.026, 0.221, -0.46 , 0.41  ,
"Acc t-PA", "ASPAC"    , 0.193 , 0.056, 0.08  , 0.30  ) %>% 
  mutate(.trt_b = ordered(trt_b, levels = levels(thrombo_net$treatments)),
         .trt = ordered(trt, levels = levels(thrombo_net$treatments)),
         rev = if_else(.trt_b > .trt, -1, 1),
         .l = lower, .u = upper,
         lower = if_else(.trt_b > .trt, .u, .l),
         upper = if_else(.trt_b > .trt, .l, .u),
         trt_b = if_else(.trt_b > .trt, .trt, .trt_b),
         trt = if_else(.trt_b > .trt, .trt_b, .trt),
         lab = paste0("d[", trt, " vs. ", trt_b, "]")) %>% 
  arrange(trt_b, trt) %>% 
  mutate_at(vars(mean, lower, upper), ~.*rev)

thrombo_releff_summary <- as.data.frame(thrombo_releff) %>% 
  filter(parameter %in% tsd_releff$lab)

test_that("FE relative effects", {
  expect_equivalent(thrombo_releff_summary$mean, tsd_releff$mean, tolerance = tol)
  expect_equivalent(thrombo_releff_summary$sd, tsd_releff$sd, tolerance = tol)
  expect_equivalent(thrombo_releff_summary$`2.5%`, tsd_releff$lower, tolerance = tol)
  expect_equivalent(thrombo_releff_summary$`97.5%`, tsd_releff$upper, tolerance = tol)
})

# DIC
test_that("DIC", {
  expect_equivalent(dic_consistency$resdev, 105.9, tolerance = tol_dic)
  expect_equivalent(dic_consistency$pd, 58, tolerance = tol_dic)
  expect_equivalent(dic_consistency$dic, 163.9, tolerance = tol_dic)
})

# Relative effects (UME)

# FE UME model, so no differences by reference treatment, no multi-arm correction
tsd_ume <- tribble(
~trt_b    , ~trt       , ~mean , ~sd  , ~lower, ~upper,
"SK"      , "t-PA"     , -0.004, 0.030, -0.06 , 0.06  ,
"SK"      , "Acc t-PA" , -0.158, 0.049, -0.25 , -0.06 ,
"SK"      , "SK + t-PA", -0.044, 0.047, -0.14 , 0.05  ,
"SK"      , "r-PA"     , -0.060, 0.089, -0.23 , 0.11  ,
"SK"      , "PTCA"     , -0.665, 0.185, -1.03 , -0.31 ,
"SK"      , "UK"       , -0.369, 0.518, -1.41 , 0.63  ,
"SK"      , "ASPAC"    , 0.005 , 0.037, -0.07 , 0.08  ,
"t-PA"    , "PTCA"     , -0.544, 0.417, -1.38 , 0.25  ,
"t-PA"    , "UK"       , -0.294, 0.347, -0.99 , 0.37  ,
"t-PA"    , "ASPAC"    , -0.290, 0.361, -1.01 , 0.41  ,
"Acc t-PA", "r-PA"     , 0.019 , 0.066, -0.11 , 0.15  ,
"Acc t-PA", "TNK"      , 0.006 , 0.064, -0.12 , 0.13  ,
"Acc t-PA", "PTCA"     , -0.216, 0.119, -0.45 , 0.02  ,
"Acc t-PA", "UK"       , 0.146 , 0.358, -0.54 , 0.86  ,
"Acc t-PA", "ASPAC"    , 1.405 , 0.417, 0.63  , 2.27  ) %>% 
  mutate(.trt_b = ordered(trt_b, levels = levels(thrombo_net$treatments)),
         .trt = ordered(trt, levels = levels(thrombo_net$treatments)),
         rev = if_else(.trt_b > .trt, -1, 1),
         .l = lower, .u = upper,
         lower = if_else(.trt_b > .trt, .u, .l),
         upper = if_else(.trt_b > .trt, .l, .u),
         trt_b = if_else(.trt_b > .trt, .trt, .trt_b),
         trt = if_else(.trt_b > .trt, .trt_b, .trt),
         lab = paste0("d[", trt, " vs. ", trt_b, "]")) %>%
  arrange(trt_b, trt) %>%
  mutate_at(vars(mean, lower, upper), ~.*rev)

thrombo_ume_releff <- summary(thrombo_fit_ume, pars = "d")

test_that("UME relative effects", {
  expect_equivalent(thrombo_ume_releff$summary$mean, tsd_ume$mean, tolerance = tol)
  expect_equivalent(thrombo_ume_releff$summary$sd, tsd_ume$sd, tolerance = tol)
  expect_equivalent(thrombo_ume_releff$summary$`2.5%`, tsd_ume$lower, tolerance = tol)
  expect_equivalent(thrombo_ume_releff$summary$`97.5%`, tsd_ume$upper, tolerance = tol)
})

# DIC (UME)
test_that("UME DIC", {
  expect_equivalent(dic_ume$resdev, 99.7, tolerance = tol_dic)
  expect_equivalent(dic_ume$pd, 65, tolerance = tol_dic)
  expect_equivalent(dic_ume$dic, 164.7, tolerance = tol_dic)
})

