% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_panel.R
\name{add_panel}
\alias{addPanel}
\alias{add_panel}
\alias{addpanel}
\title{add_panel}
\usage{
add_panel(figure, panel, top_panel = 1, bottom_panel = top_panel,
  left_panel = 1, right_panel = left_panel, label = NULL,
  label_just = c("right", "bottom"), panel_clip = c("on", "off", "inherit"),
  ...)
}
\arguments{
\item{figure}{Object of classes \code{multipanelfigure}/
\code{\link[gtable]{gtable}} as produced by \code{\link{multi_panel_figure}}
and representing the figure the panel is to be placed in.}

\item{panel}{Single \code{\link{character}} object representing path to a
bitmap image (\code{*.png}, \code{*.tiff}/\code{*.tif},
\code{*.jpg}/\code{*.jpeg}), a \code{\link[ggplot2]{ggplot}} object , a
\code{\link[lattice]{trellis.object}}, a \code{\link[grid]{gList}} object or
a \code{\link[grid]{grob}} object to be placed in a multipanel figure. See
'Details'.}

\item{top_panel}{Single \code{\link{numeric}} indicating the row index of
the panel that is to be placed in the figure.}

\item{bottom_panel}{Single \code{\link{numeric}} indicating the lower row
index of the panel that is to be placed in the figure. Important for
definition of panel spanning (see examples).}

\item{left_panel}{Single \code{\link{numeric}} indicating the column index
of the panel that is to be placed in the figure.}

\item{right_panel}{Single \code{\link{numeric}} indicating the right column
index of the panel that is to be placed in the figure. Important for
definition of panel spanning (see examples).}

\item{label}{Single \code{\link{character}} object defining the panel
label used for automated annotation.}

\item{label_just}{Justification for the label within the interpanel spacing
grob to the top-left of the panel content grob.  Passed to
\code{\link[grid]{textGrob}}.}

\item{panel_clip}{Should the display of panel contents be clipped at the
panel borders?  See \code{\link[grid]{viewport}}.}

\item{...}{Additional arguments passed to \code{\link[utils]{download.file}}
when adding PNG, TIFF, or JPEG panels from URL.}
}
\value{
Returns the \code{\link[gtable]{gtable}} object fed to it
(\code{figure}) with the addition of the \code{panel}.
}
\description{
A convenience function adding graphical objects to a
\code{\link[gtable]{gtable}} constructed by \code{\link{multi_panel_figure}}.
}
\details{
Currently supported as panel-representing objects (\code{panel}) are
\enumerate{
  \item{ggplot2 \code{\link[ggplot2]{ggplot}} objects.}
  \item{grid \code{\link[grid]{grob}}, \code{\link[grid]{gList}}, and
    \code{\link[grid]{gTree}} objects.}
  \item{lattice \code{\link[lattice]{trellis.object}}s.}
  \item{Single \code{\link{character}} objects representing URLs or paths to
    readable portable network graphics (\code{*.png}), tagged image file
    format (\code{*.tiff}/\code{*.tif}), joint photographic experts group
    (\code{*.jpg}/\code{*.jpeg}) files, or support vector graphics
    (\code{*.svg}) which will be read and placed into panels as requested.}}
Note that \code{*.jpg}/\code{*.jpeg} files must be produced
using the dimensions of the panel(s) they are to be placed in for sensible
results. \code{\link[ggplot2]{ggplot}} objects obviously auto-scale and
\code{*.tiff}/\code{*.tif}, as well as \code{*.png} files have their native
sizes read out of the file (which isn't working for
\code{*.jpg}/\code{*.jpeg}).  \code{*.svg} files are converted to a raster
object the size of the panel.
\pkg{lattice}-generated \code{\link[lattice]{trellis.object}}s are converted
tp \code{grob}s using \code{grid.grabExpr(print(x))}, the side effects of
which with respect to plot formatting are not well studied.
}
\examples{
# Create the figure layout
(figure <- multi_panel_figure(
  widths = c(30,40,60),
  heights = c(40,60,60,60),
  panel_label_type = "upper-roman"))

# Fill the top-left panel using a grob object directly
a_grob <- grid::linesGrob(arrow = grid::arrow())
figure \%<>\% add_panel(a_grob)

# Add a ggplot object directly to the top row, second column.
a_ggplot <- ggplot2::ggplot(mtcars, ggplot2::aes(disp, mpg)) +
  ggplot2::geom_point()
figure \%<>\% add_panel(a_ggplot, left_panel = 2)

# JPEG, PNG, TIFF, and SVG images are added by passing the path to their file.
image_files <- system.file("extdata", package = "multipanelfigure") \%>\%
  dir(full.names = TRUE) \%>\%
  setNames(basename(.))

# Add the JPEG to the top row, third column
figure \%<>\% add_panel(image_files["rhino.jpg"], left_panel = 3)

# Add the PNG to the second and third row, first and second column
figure \%<>\% add_panel(
  image_files["Rlogo.png"],
  top_panel = 2, bottom_panel = 3, left_panel = 1, right_panel = 2)

# Add the TIFF to the second row, third column
figure \%<>\% add_panel(
  image_files["unicorn.svg"],
  top_panel = 2, left_panel = 3)

# lattice/trellis plot objects are also added directly
Depth <- lattice::equal.count(quakes$depth, number=4, overlap=0.1)
a_lattice_plot <- lattice::xyplot(lat ~ long | Depth, data = quakes)
# Add the lattice plot to the third row, third column
figure \%<>\% add_panel(
  a_lattice_plot,
  top_panel = 3, left_panel = 3)

# Incorporate a gList object (such as produced by VennDigram)
if(requireNamespace("VennDiagram"))
{
  a_venn_plot <- VennDiagram::draw.pairwise.venn(50, 30, 20, ind = FALSE)
  # Add the Venn diagram to the fourth row, first and second columns
  (figure \%<>\% add_panel(
    a_venn_plot,
    top_panel = 4, left_panel = 1, right_panel = 2))
}

# Incorporate a base plot figure
a_base_plot <- capture_base_plot(
 heatmap(
   cor(USJudgeRatings), Rowv = FALSE, symm = TRUE, col = topo.colors(16),
   distfun = function(c) as.dist(1 - c), keep.dendro = TRUE,
   cexRow = 0.5, cexCol = 0.5))
# Add the heatmap to the fourth row, third column
(figure \%<>\% add_panel(
  a_base_plot,
  top_panel = 4, left_panel = 3))
}
\author{
Johannes Graumann
}
\seealso{
\code{\link[gtable]{gtable}}, \code{\link{multi_panel_figure}},
\code{\link[tiff]{readTIFF}}, \code{\link[png]{readPNG}},
\code{\link[jpeg]{readJPEG}}
}

