% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture_base_plot.R
\name{capture_base_plot}
\alias{capture_base_plot}
\alias{capturebaseplot}
\title{Capture a base plot}
\usage{
capture_base_plot(expr)
}
\arguments{
\item{expr}{A expression that draws a plot using base graphics.}
}
\value{
An object of class \code{gTree}.
}
\description{
Capture a plot drawn using base graphics as a grid \code{grob}.
}
\note{
A side effect of this function is that plots get drawn twice: once as
a base plot, and secondly as a grid plot.
}
\examples{
p <- capture_base_plot(hist(rnorm(1000), seq(-4, 4, 0.2)))
grid::grid.draw(p)
# If the plot takes multiple lines to draw, then wrap the code in braces.
p2 <- capture_base_plot({
  par(las = 1)
  plot(1:5)
  title("One to five")
})
grid::grid.draw(p2)
}
\seealso{
\code{\link[gridGraphics]{grid.echo}}, \code{\link[grid]{grid.grab}}
}

