% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{distribute}
\alias{distribute}
\title{Calculations for how to distribute x items over N nodes}
\usage{
distribute(x, N)
}
\arguments{
\item{x}{Number of items or a vector of group sizes}

\item{N}{Number of nodes}
}
\value{
A vector containing number of rows or a list containing the indices of groups
}
\description{
This function is used to determine how to distribute the contents of a
data frame across the cluster. It may either be called with a single number
representing the total number of rows, or it may be called with a vector of
numbers representing the size of groups.
}
\examples{
distribute (100, 4)
distribute (c(25, 25, 50), 2)
}
\seealso{
Other utility functions: \code{\link{between}},
  \code{\link{cumall}}, \code{\link{cumany}},
  \code{\link{cummean}}, \code{\link{first}},
  \code{\link{lag}}, \code{\link{last}},
  \code{\link{lead}}, \code{\link{n_distinct}},
  \code{\link{n_groups}}, \code{\link{nth}},
  \code{\link{n}}
}

