% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{lib.clean}
\alias{lib.clean}
\title{Clean multiversion library, revert to state of last commit.}
\usage{
lib.clean(lib_location = lib.location(), clean_temp_lib = TRUE)
}
\arguments{
\item{lib_location}{By default the library path returned by \code{lib.location()} is used. See Note.}

\item{clean_temp_lib}{If true, will also run \code{lib.clean_install_dir()}.}
}
\value{
Clean up all un-tracked (not committed) installed libraries in the multiversion library.
  Will additionally also clean up the TEMP_install_location directory (this is an 'ignored' directory).
  Will ask for permission when being called in an interactive session.
}
\description{
Clean up all un-tracked (not committed) installed libraries in the multiversion library.
Will additionally also clean up the TEMP_install_location directory (this is an 'ignored' directory).
}
\details{
Since it involves a quite invasive operation, it asks for permission when being called in an interactive session.
}
\note{
It will build the most likely installation directory based on the
\code{lib_location} you provide. See \code{\link{lib.location_install_dir}}. Which is \code{<your lib>/TEMP_install_location}.
}
