% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{scale_palette}
\alias{scale_palette}
\title{Orbit of a scale under symmetries of hyperplane arrangement}
\usage{
scale_palette(set, include_involution = TRUE, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{include_involution}{Should involutional symmetry be included in the
applied transformation group? Defaults to \code{TRUE}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
A matrix whose columns represent the colors in \code{set}'s palette.
}
\description{
Given an input scale, return a "palette" of related scalar colors. All the returned
scales are the image of the input under some \code{\link[=ineqsym]{ineqsym()}}.
}
\examples{
# The palette of a minor triad is all inversions of major and minor:
minor_triad <- c(0, 3, 7)
scale_palette(minor_triad)

# But 12edo is a little too convenient. The palette of the just minor triad
# involves some less-consonant intervals:
just_minor <- j(1, m3, 5)
scale_palette(just_minor)

# The palette of the diatonic scale includes all 42 well-formed heptachord colors:
dia_palette <- scale_palette(sc(7, 35))
dim(dia_palette)
table(apply(dia_palette, 2, iswellformed))

}
