% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimize_VL.R
\name{whichmodebest}
\alias{whichmodebest}
\title{Smallest crossing-free voice leading between two pitch-class sets}
\usage{
whichmodebest(
  source,
  goal,
  method = c("taxicab", "euclidean", "chebyshev", "hamming"),
  no_ties = FALSE,
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{source}{Numeric vector, the pitch-class set at the start of your voice leading}

\item{goal}{Numeric vector, the pitch-class set at the end of your voice leading}

\item{method}{What distance metric should be used? Defaults to \code{"taxicab"}
but can be \code{"euclidean"}, \code{"chebyshev"}, or \code{"hamming"}.}

\item{no_ties}{If multiple VLs are equally small, should only one be returned? Defaults to \code{FALSE}, which
is generally what an interactive user should want.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric value(s) identifying the modes of \code{goal}. Single value if \code{no_ties} is \code{TRUE},
otherwise n values for an n-way tie.
}
\description{
Given source and goal pitch-class sets, which mode of the goal is closest to the source
(assuming crossing-free voice leadings and the given \code{method} for determining distance).
}
\examples{
c_53 <- c(0, 4, 7)
c_64 <- c(7, 0, 4)
d_53 <- c(2, 6, 9)
e_53 <- c(4, 8, 11)

whichmodebest(c_53, c_64)
whichmodebest(c_64, c_53)
whichmodebest(c_53, e_53)
whichmodebest(c_53, d_53)
whichmodebest(c_53, d_53, method="euclidean")

# See "Modal Color Theory," p. 12, note 21
pyth_dia_modes <- sim(sort((j(5) * 0:6)\%\%12))
pyth_lydian <- pyth_dia_modes[,1]
pyth_locrian <- pyth_dia_modes[,4]
whichmodebest(pyth_locrian, pyth_lydian) 
}
