\name{cd}
\alias{cd}
\title{Organizing R workspaces}
\description{\code{cd} allows you to set up and move through a hierarchically-organized set of \R workspaces, each corresponding to a directory. While working at any level of the hierarchy, all higher levels are attached on the search path, so you can see objects in the "parents". You can easily switch between workspaces in the same session, you can move objects around in the hierarchy, and you can do several hierarchy-wide things such as searching, even on parts of the hierarchy that aren't currently attached.}
\synopsis{cd( to, execute.First=TRUE, execute.Last=TRUE)}
\usage{
 cd()
 cd(to)
 cd(to, execute.First = TRUE, execute.Last = TRUE)
}
\arguments{
\item{ to}{the path of a task to move to or create, as an unquoted string. If omitted, you'll be given a menu. See DETAILS.}
\item{ execute.First}{should the \code{.First.task} code be executed on attachment? Yes, unless there's a bug in it.}
\item{ execute.Last}{should the \code{.Last.task} code be executed on detachment? Yes, unless there's a bug in it.}
}
\details{
\R workspaces can become very cluttered, so that it becomes difficult to keep track of what's what (I have seen workspaces with over 1000 objects in them\dots). If you work on several different projects, it can be awkward to work out where to put "shared" functions-- or to remember where things are, if you come back to a project after some months away. And if you just want to test out a bit of code without leaving permanent clutter, but while still being able to "see" your important objects, how do you do it? \code{cd} helps with all such problems, by letting you organize all your projects into a single tree structure, regardless of where they are stored on disk. Each workspace is referred to (for historical reasons) as a "task".

To use the \code{cd} system, you will need to start \R in the \emph{same} workspace every time. This will become your ROOT or home task, from which all other tasks stem. There need not be much in this workspace except for an object called \code{tasks} (see below), though you can use it for shared functions that you don't want to organize into a package or quasi-package. From the ROOT task, your first action in a new \R session will normally be to use \code{cd} to switch to a real task. The \code{cd} command is used both to switch between existing tasks, and to create new ones.

To set yourself up for working with \code{cd}, it's probably a good idea to make the ROOT task a completely new blank workspace. [In MS-Windows, I'd suggest putting it near the top of the disk directory structure, too.] Start \R in this workspace, type \code{library( mvbutils)}, and then start linking your existing projects into the hierarchy. To link in a project, just type \code{cd()} and a menu will appear. The first time, there will be only one option: "CREATE NEW TASK". Select it (or type 0 to quit if you are feeling nervous), and you will be prompted for a "task name", by which \R will always subsequently refer to the task. Keep the name short; it doesn't have to be related to the location of the disk directory where the .Rdata lives. Avoid spaces and weird characters-- use periods as separators. Task names are case-sensitive. Next, you'll be asked which disk directory this task refers to. By default, \code{cd} expects that you are creating a new task, and therefore suggests putting the directory immediately below the current task directory. However, if you are linking in an existing project, you'll need to supply the directory name. Next, you'll be returned to the \R command prompt-- but the prompt will have changed, so that the ">" is preceded by the task name. If you type \code{search()}, you'll see your ROOT task in position 2, below .GlobalEnv as usual. Despite the name, though, the new .GlobalEnv contains the project you've just linked, and if you type \code{ls()}, you should see some familiar objects. Now type \code{cd(0)} to move back to the ROOT task (note the changed prompt), type \code{search()} and \code{ls()} again to orient yourself, and proceed as before to link the rest of your pre-existing tasks into the hierarchy. When you type \code{cd()}, the menu will have more choices. If you select an existing task rather than creating a new one, you will switch straightaway to that workspace; watch the prompt.

Once you have a hierarchy set up, you can switch the current workspace within the hierarchy by calling e.g. \code{cd(existing.task)} (note the lack of quotes), or by calling \code{cd()} and picking off the menu. You can move through several levels of the hierarchy at once, using a path specifier such as \code{cd(mytask/data/funcs)} or \code{cd(../child.of.sibling)}. Path specifiers are just like Unix or DOS disk paths with "/" as the separator, so that "." means "current task" and ".." means "parent". However, the character 0 must be used to denote the ROOT task, so that you have to type \code{cd(0/different.task)} rather than \code{cd(/different.task}). You can display the entire hiearchy by calling \code{cdtree(0)}, or graphically via \code{plot( cdtree( 0))}.

When you first set up your task hierarchy, you'll also want to create or modify the \code{.First} function in your ROOT task. At a minimum, this should call \code{library( mvbutils)}, but you may also want to set some options controlling the behaviour of \code{cd} (see the OPTIONS section). If you use other features of \code{mvbutils} such as the function-editing interface, there will be further options to be set in \code{.First}.

You can create a fully hierarchical structure, with subtasks within subtasks within tasks, etc. Even if your projects don't naturally look like this, you may find the facility useful. When I create a new project, I tend to start with just one level of hierarchy, containing data, function code, and results. When this gets unspeakably messy, I often create one (or more) subtasks, usually putting the basic data at the top level, and functions and results at the lower level. Apart from tidiness, this provides some degree of protection against overwriting the original data. And when even this gets too messy-- in one task, I have more than 150 functions, and it is very easy to generate 100s of analysis results-- I create another level, keeping "established" functions at the second tier and using the third tier for temporary workspace and results. There are no hard-and-fast rules here, of course, and different people use \R in very different ways.

A task can have \code{.First.task} and/or \code{.Last.task} functions, which get called immediately after \code{cd}ing into the task from its parent, or immediately before \code{cd}ing back to its parent, respectively (see ARGUMENTS). These can be useful for dynamic loading, etc., and facilitate the use of tasks as informal libraries/packages (see also \code{flatdoc}).

Formal and semi-formal packages can also be tasks. For example, my \code{mvbutils}, \code{debug} and \pkg{handy} packages are loaded by \code{library} when I start \R (in my \code{.First}), but are also linked into my task hierarchy (see also \code{mlibrary}). This lets me \code{cd(debug)} when I intend to create or remove a number of functions in \code{debug}. It's also useful to be able to have subtasks below such packages, e.g. so that probably-obsolete functions can be moved there pending a final decision. When you \code{cd} to something that's already attached as a package, \code{search()} will show e.g. "PLACEHOLDER:debug" in the position formerly occupied by the package; when you \code{cd} back up, the package will return to the placeholder slot.

With the \code{cd} approach, the idea is really that everything (including functions) is stored in a single .Rdata file, rather than as separate files to be \code{source}d in when you switch to a project; this reflects my own preference for how to work. Before \code{cd} moves to a new project, either up or down the hierarchy, the current workspace is automatically \code{save.image}d (using default arguments). Nevertheless, I don't think \code{cd} is incompatible with other ways of working, as long as the .Rdata file (actually the \code{tasks} object) is not destroyed from session to session. At any rate, some people who work by \code{source}ing large code files still seem to find \code{cd} useful. With the .Rdata-only approach, it is highly advisable to have some way of keeping separate text backups, at least of function code. The \code{fixr} editing system is geared up to this, and I presume other systems such as ESS are too.
}
\section{Options}{
Various \code{options()} can be set, as follows. Remember to put these into your \code{.First} function, too.

\code{write.mvb.tasks=TRUE} causes a sourceable text representation of the \code{tasks} object to be maintained in each directory, in the file \code{tasks.r}. This helps in case you accidentally wipe out the .Rdata file and lose track of where the child tasks live. To create these text representations for the first time throughout the hierarchy, call \code{cd.write.mvb.tasks(0)}. You need to put the the \code{options} call in your \code{.First}.

\code{options(abbreviate.cdprompt(n))} controls the length of the prompt string. Only the first \code{n} characters of all ancestral task names will be shown. For example, \code{n=1} would replace the prompt \code{long.task.name/data/funcs>} with \code{l/d/funcs>}.
}
\note{
\code{cd} always calls \code{save.image} before attaching a child task on top or moving back up the hierarchy. \code{cd} also calls \code{setwd} so that file searches will default to the task directory (see also \code{task.home}).

\code{cd} is only meant to be called interactively, and has only been tested in that context.

The mechanism underlying the tree structure is very simple: each task that has any subtasks will contain a character vector called \code{tasks}, whose names are the \R names of the tasks, and whose elements are the corresponding disk directories. Your ROOT task need contain no more than a \code{.First} function and a \code{tasks} object. If you decide to move a disk directory, you can manually change the corresponding element of \code{tasks}. If you are moving a whole task hierarchy, e.g. when migrating to a new machine, consult \code{cd.change.all.paths}.

\code{cd} will issue a warning and refuse to move back up the hierarchy if it detects a non-task attached in position 2. You will need to manually detach any such objects before \code{cd}ing back up. \code{cd} is not really designed to work with \code{attach}, and fans of the latter may encounter problems; if so, please let me know.

To make sure that \code{library} always loads packages below ROOT, the \code{.First.lib} code in \code{mvbutils} makes a minor hack to \code{library}, setting the default \code{pos} argument to call \code{lib.pos()}.

Two objects in the \code{mvb.session.info} environment (see \code{search()}) help keep track of what parts of the hierarchy are currently attached; \code{.First.top.search} and \code{.Path}. The former is set when \code{mvbutils} loads, and the latter is updated by \code{cd}. Attached tasks can be identified by having a \code{path} attribute consisting of a NAMED character vector. Normal packages also have a \code{path} attribute, but lacking names.
}
\seealso{ \code{\link{move}}, \code{\link{task.home}}, \code{\link{cdtree}}, \code{\link{cdfind}}, \code{\link{cditerate}}, \code{\link{cd.change.all.paths}}, \code{\link{cd.write.mvb.tasks}}, \code{\link{cdprompt}}, \code{\link{fixr}}}
\author{Mark Bravington}
\keyword{utilities}
