% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.mvgam.R
\name{forecast.mvgam}
\alias{forecast.mvgam}
\alias{forecast}
\title{Extract or compute hindcasts and forecasts for a fitted \code{mvgam} object}
\usage{
forecast(object, ...)

\method{forecast}{mvgam}(object, newdata, data_test, n_cores = 1, type = "response", ...)
}
\arguments{
\item{object}{\code{list} object returned from \code{mvgam}. See \code{\link[=mvgam]{mvgam()}}}

\item{...}{Ignored}

\item{newdata}{Optional \code{dataframe} or \code{list} of test data containing at least 'series' and 'time'
in addition to any other variables included in the linear predictor of the original \code{formula}. If included, the
covariate information in \code{newdata} will be used to generate forecasts from the fitted model equations. If
this same \code{newdata} was originally included in the call to \code{mvgam}, then forecasts have already been
produced by the generative model and these will simply be extracted and plotted. However if no \code{newdata} was
supplied to the original model call, an assumption is made that the \code{newdata} supplied here comes sequentially
after the data supplied in the original model (i.e. we assume there is no time gap between the last
observation of series 1 in the original data and the first observation for series 1 in \code{newdata})}

\item{data_test}{Deprecated. Still works in place of \code{newdata} but users are recommended to use
\code{newdata} instead for more seamless integration into \code{R} workflows}

\item{n_cores}{\code{integer} specifying number of cores for generating forecasts in parallel}

\item{type}{When this has the value \code{link} (default) the linear predictor is
calculated on the link scale.
If \code{expected} is used, predictions reflect the expectation of the response (the mean)
but ignore uncertainty in the observation process. When \code{response} is used,
the predictions take uncertainty in the observation process into account to return
predictions on the outcome scale. When \code{variance} is used, the variance of the response
with respect to the mean (mean-variance relationship) is returned.
When \code{type = "terms"}, each component of the linear predictor is
returned separately in the form of a \code{list} (possibly with standard
errors, if \code{summary = TRUE}): this includes parametric model components,
followed by each smooth component, but excludes any offset and any intercept.
Two special cases are also allowed:
type \code{latent_N} will return the estimated latent abundances from an
N-mixture distribution, while type \code{detection} will return the estimated
detection probability from an N-mixture distribution}
}
\value{
An object of class \code{mvgam_forecast} containing hindcast and forecast distributions.
See \code{\link{mvgam_forecast-class}} for details.
}
\description{
Extract or compute hindcasts and forecasts for a fitted \code{mvgam} object
}
\details{
Posterior predictions are drawn from the fitted \code{mvgam} and used to simulate a forecast distribution
}
\examples{
\donttest{
simdat <- sim_mvgam(n_series = 3, trend_model = AR())
mod <- mvgam(y ~ s(season, bs = 'cc', k = 6),
            trend_model = AR(),
            noncentred = TRUE,
            data = simdat$data_train,
            chains = 2)

# Hindcasts on response scale
hc <- hindcast(mod)
str(hc)
plot(hc, series = 1)
plot(hc, series = 2)
plot(hc, series = 3)

# Forecasts on response scale
fc <- forecast(mod, newdata = simdat$data_test)
str(fc)
plot(fc, series = 1)
plot(fc, series = 2)
plot(fc, series = 3)

# Forecasts as expectations
fc <- forecast(mod, newdata = simdat$data_test, type = 'expected')
plot(fc, series = 1)
plot(fc, series = 2)
plot(fc, series = 3)

# Dynamic trend extrapolations
fc <- forecast(mod, newdata = simdat$data_test, type = 'trend')
plot(fc, series = 1)
plot(fc, series = 2)
plot(fc, series = 3)
}
}
\seealso{
\code{\link{hindcast}}, \code{\link{score}}
}
