% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{power.msk}
\alias{power.msk}
\title{Power Calculation using the Bowman and Shenton Test Statistic}
\usage{
power.msk(a, n, p, B = 1000, FUN, ...)
}
\arguments{
\item{a}{significance level (\eqn{\alpha}).}

\item{n}{number of rows (observations).}

\item{p}{number of columns (variables), \eqn{n>p}.}

\item{B}{number of Monte Carlo simulations, default is 1000 (can increase B to increase the precision).}

\item{FUN}{self-defined function for generate multivariate distribution. See example.}

\item{...}{optional arguments passed to \code{FUN}.}
}
\value{
Returns a numeric value of the estimated empirical power (value between 0 and 1).
}
\description{
Empirical power calculation using Bowman and Shenton Test Statistic.
}
\examples{
set.seed(12345)

## Power calculation against bivariate (p=2) independent Beta(1, 1) distribution ##
## at sample size n=50 at one-sided alpha = 0.05 ##

power.msk(a = 0.05, n = 50, p = 2,  B = 100, FUN=IMMV, D1=runif)

}
\references{
Bowman, K. O., & Shenton, L. R. (1975). Omnibus test contours for departures from normality based on \eqn{\sqrt b_1} and \eqn{b_2}. \emph{Biometrika}, 62(2), 243-250.
}
