## ----set-options, echo = FALSE------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>", dev = "png", fig.width = 7, fig.height = 3.5, message = FALSE, warning = FALSE)
options(width = 80, tibble.width = Inf)

## -----------------------------------------------------------------------------
library("mvp",quietly=TRUE)
p <- as.mvp("3x y + z^3 + x y^6 z")
p

## -----------------------------------------------------------------------------
M <- as.mvp("3 stoat*goat^6 -4 + 7 stoatboat^3 * bloat -9 float*boat*goat*gloat^6")
M
dput(M)

## -----------------------------------------------------------------------------
print(M,order="lex", varorder=c("stoat","goat","boat","bloat","gloat","float","stoatboat"))

## -----------------------------------------------------------------------------
S1 <- rmvp(5,2,2,4)
S2 <- rmvp(5,2,2,4)
S1
S2
S1+S2
S1*S2
S1^2

## -----------------------------------------------------------------------------
S3 <- as.mvp("x + 5x^4*y + 8y^2*x*z^3")
S3

## -----------------------------------------------------------------------------
subs(S3,x=1)

## -----------------------------------------------------------------------------
subs(S3,x=1,y=2,z=3)

## -----------------------------------------------------------------------------
subsmvp(S3,"z",as.mvp("a^2+2b^3"))

## -----------------------------------------------------------------------------
S <- rmvp(5,4,6,4)
S
deriv(S,letters[1:3])
deriv(S,rev(letters[1:3]))  # should be the same.

## -----------------------------------------------------------------------------
aderiv(S,a=3,b=1,c=2)

## -----------------------------------------------------------------------------
p <- as.mvp("1+x+x^2 y")
p
invert(p)

## -----------------------------------------------------------------------------
knight(2)

## -----------------------------------------------------------------------------
constant(knight(4)^4)

## -----------------------------------------------------------------------------
library("spray")
library("mpoly")
a1 <- rmvp(30,9,9,26)
a2 <- as.mpoly(a1)
a3 <- mvp_to_spray(a1)
system.time(ignore <- a1^3)  # mvp
system.time(ignore <- a2^3)  # mpoly
system.time(ignore <- a3^3)  # spray

