% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mvtb_plots.R
\name{mvtb.perspec}
\alias{mvtb.perspec}
\title{Perspective plot for 2 predictors and 1 response.}
\usage{
mvtb.perspec(out, response.no = 1, predictor.no = 1:2, n.trees = NULL,
  phi = 15, theta = -55, r = sqrt(10), d = 3, ticktype = "detailed",
  ...)
}
\arguments{
\item{out}{mvtb output object}

\item{response.no}{index of the response variable}

\item{predictor.no}{vector containing indeces of the predictor variables to plot}

\item{n.trees}{desired number of trees (default: best trees)}

\item{phi}{angle of viewing direction. See ?persp.}

\item{theta}{angle of viewing direction See ?persp.}

\item{r}{distance from eye to center. See ?persp}

\item{d}{strength of perspective. See ?persp.}

\item{ticktype}{'detailed' gives axis points. See ?persp for other options.}

\item{...}{extra arguments are passed to persp. See ?persp}
}
\value{
Function is called for it's side effect, a plot.
}
\description{
This is a plot of the model implied function of 2 predictors averaged over the other predictors
included in the model. This is called a partial dependence plot.
As an alternative to the perspective (3D) plot, a 2D heat plot can be obtained directly
using ?plot.gbm.
}
\seealso{
\code{plot.gbm}, \code{plot.mvtb}, \code{heat.covex}
}

