/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.solver;

import ilog.concert.IloException;
import ilog.concert.IloIntVar;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.cplex.IloCplex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import ru.itmo.ctlab.gmwcs.solver.D;
import ru.itmo.ctlab.gmwcs.solver.TreeSolverKt;
import ru.itmo.ctlab.virgo.Pair;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.gmwcs.graph.Blocks;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;
import ru.itmo.ctlab.virgo.gmwcs.solver.CplexSolution;
import ru.itmo.ctlab.virgo.gmwcs.solver.IloVarHolder;
import ru.itmo.ctlab.virgo.gmwcs.solver.MSTSolver;
import ru.itmo.ctlab.virgo.gmwcs.solver.RootedSolver;
import ru.itmo.ctlab.virgo.gmwcs.solver.Separator;

public class RLTSolver
extends IloVarHolder
implements RootedSolver {
    public static final double EPS = 0.01;
    private IloCplex cplex;
    private Map<Node, IloNumVar> y;
    private Map<Edge, IloNumVar> w;
    private Map<IloNumVar, Double> mstWeights;
    private Map<Edge, Pair<IloNumVar, IloNumVar>> x;
    private Map<Node, IloNumVar> d;
    private Map<Node, IloNumVar> x0;
    private TimeLimit tl = new TimeLimit(Double.POSITIVE_INFINITY);
    private int threads = 1;
    private boolean suppressOutput;
    private Graph graph;
    private double minimum = -1.7976931348623157E308;
    private Node root;
    private boolean isSolvedToOptimality;
    private int maxToAddCuts;
    private int considerCuts = Integer.MAX_VALUE;

    public RLTSolver() {
        this.maxToAddCuts = Integer.MAX_VALUE;
    }

    public void setMaxToAddCuts(int num) {
        this.maxToAddCuts = num;
    }

    public void setConsideringCuts(int num) {
        this.considerCuts = num;
    }

    @Override
    public void setTimeLimit(TimeLimit tl) {
        this.tl = tl;
    }

    public void setThreadsNum(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException();
        }
        this.threads = threads;
    }

    @Override
    public void setRoot(Node root) {
        this.root = root;
    }

    public void initMstWeights() {
        this.mstWeights = new HashMap<IloNumVar, Double>();
        for (Edge e : this.graph.edgeSet()) {
            this.mstWeights.put(this.w.get(e), e.getWeight() >= 0.0 ? 1.0 : 0.0);
        }
        for (Node n : this.graph.vertexSet()) {
            this.mstWeights.put(this.y.get(n), n.getWeight() >= 0.0 ? 1.0 : 0.0);
        }
    }

    @Override
    public List<Elem> solve(Graph graph) throws SolverException {
        try {
            this.cplex = new IloCplex();
            this.setCplexLog();
            this.graph = graph;
            this.initVariables();
            this.addConstraints();
            this.addObjective();
            this.maxSizeConstraints();
            this.initMstWeights();
            long timeBefore = System.currentTimeMillis();
            if (this.root == null) {
                this.breakRootSymmetry();
            } else {
                this.tighten();
            }
            this.breakTreeSymmetries();
            this.tuning(this.cplex);
            if (!this.suppressOutput) {
                this.cplex.use((IloCplex.Callback)new LogCallback());
            }
            if (graph.vertexSet().size() >= 25) {
                this.cplex.use((IloCplex.Callback)new MstCallback(0));
                this.tryMst(this);
            }
            boolean solFound = this.cplex.solve();
            this.tl.spend(Math.min(this.tl.getRemainingTime(), (double)(System.currentTimeMillis() - timeBefore) / 1000.0));
            if (solFound) {
                List<Elem> list = this.getResult();
                return list;
            }
            List<Elem> list = Collections.emptyList();
            return list;
        }
        catch (IloException e) {
            throw new SolverException(e.getMessage());
        }
        finally {
            this.cplex.end();
        }
    }

    private void setCplexLog() {
        if (this.suppressOutput) {
            this.cplex.setOut(null);
            this.cplex.setWarning(null);
        }
    }

    @Override
    protected void setSolution(IloNumVar[] v, double[] d) throws IloException {
        this.cplex.addMIPStart(v, d);
    }

    @Override
    protected double getValue(IloNumVar v) throws IloException {
        return this.mstWeights.get(v);
    }

    private CplexSolution tryMstSolution(Graph tree, Node root, Set<Node> mstSol) {
        IloNumVar to;
        IloNumVar from;
        Iterator u;
        Edge e;
        Object cur;
        CplexSolution solution = new CplexSolution();
        HashSet<Edge> unvisitedEdges = new HashSet<Edge>(this.graph.edgeSet());
        HashSet<Node> unvisitedNodes = new HashSet<Node>(this.graph.vertexSet());
        ArrayDeque<Node> deque = new ArrayDeque<Node>();
        deque.add(root);
        HashMap<Node, Integer> ds = new HashMap<Node, Integer>();
        ds.put(root, 0);
        HashSet<Node> visitedNodes = new HashSet<Node>();
        HashSet<Edge> visitedEdges = new HashSet<Edge>();
        visitedNodes.add(root);
        mstSol.remove(root);
        while (!deque.isEmpty()) {
            solution.addVariable(this.x0, cur, (cur = (Node)deque.pollFirst()) == root ? 1.0 : 0.0);
            solution.addVariable(this.y, cur, 1.0);
            List list = tree.neighborListOf((Node)cur).stream().filter(arg_0 -> this.lambda$tryMstSolution$0(mstSol, tree, (Node)cur, visitedNodes, arg_0)).collect(Collectors.toList());
            visitedNodes.addAll(list);
            mstSol.removeAll(list);
            for (Node node : list) {
                e = tree.getEdge(node, (Node)cur);
                unvisitedEdges.remove(e);
                visitedEdges.add(e);
                solution.addVariable(this.w, e, 1.0);
                deque.add(node);
            }
        }
        unvisitedNodes.removeAll(visitedNodes);
        for (Edge edge : new ArrayList<Edge>(unvisitedEdges)) {
            u = this.graph.getEdgeSource(edge);
            Node node = this.graph.getEdgeTarget(edge);
            from = this.getX(edge, (Node)((Object)u));
            to = this.getX(edge, node);
            if (visitedNodes.contains(u) && visitedNodes.contains(node) && edge.getWeight() >= 0.0) {
                unvisitedEdges.remove(edge);
                visitedEdges.add(edge);
                continue;
            }
            solution.addNullVariables(this.w.get(edge), from, to);
        }
        deque.add(root);
        visitedNodes.remove(root);
        while (!deque.isEmpty()) {
            cur = (Node)deque.poll();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Edge edge : this.graph.edgesOf((Node)cur).stream().filter(visitedEdges::contains).collect(Collectors.toList())) {
                arrayList.add(this.graph.opposite((Node)cur, edge));
            }
            for (Node node : arrayList) {
                if (!visitedNodes.contains(node)) continue;
                deque.add(node);
                visitedNodes.remove(node);
                e = this.graph.getEdge(node, (Node)cur);
                solution.addVariable(this.getX(e, node), 1.0);
                solution.addVariable(this.getX(e, (Node)cur), 0.0);
                visitedEdges.remove(e);
                ds.put(node, (Integer)ds.get(cur) + 1);
            }
        }
        for (Edge edge : visitedEdges) {
            u = this.graph.getEdgeSource(edge);
            Node node = this.graph.getEdgeTarget(edge);
            from = this.getX(edge, (Node)((Object)u));
            to = this.getX(edge, node);
            solution.addVariable(this.w, edge, 1.0);
            solution.addNullVariables(from, to);
        }
        assert (visitedNodes.isEmpty());
        for (Map.Entry entry : ds.entrySet()) {
            solution.addVariable(this.d, (Elem)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        for (Node node : unvisitedNodes) {
            solution.addNullVariables(this.x0.get(node), this.d.get(node), this.y.get(node));
        }
        return solution;
    }

    private boolean isGoodNode(Node node, Edge edge, Set<Node> visited) {
        return node.getWeight() + edge.getWeight() >= 0.0 && !visited.contains(node);
    }

    private void tryMst(IloVarHolder hld) throws IloException {
        double best;
        Map<Edge, Double> ews = hld.buildVarGraph(this.graph, this.y, this.w);
        D solution = null;
        Graph gr = null;
        for (Set<Node> set : this.graph.connectedSets()) {
            if (set.isEmpty()) continue;
            Node root = Optional.ofNullable(this.root).orElse(set.stream().max(Comparator.comparingDouble(Elem::getWeight)).get());
            Graph g = this.graph.subgraph(set);
            if (!g.containsVertex(root)) continue;
            MSTSolver mst = new MSTSolver(g, ews, root);
            mst.solve();
            g = this.graph.subgraph(g.vertexSet(), new HashSet<Edge>(mst.getEdges()));
            D sol = TreeSolverKt.solve(g, root, null);
            if (solution != null && !(solution.getBestD() < sol.getBestD())) continue;
            solution = sol;
            gr = g;
        }
        if (solution != null && (best = solution.getWithRootD()) > 0.0) {
            CplexSolution sol = this.tryMstSolution(gr, solution.getRoot(), solution.getWithRoot());
            hld.setSolution(sol.variables(), sol.values());
        }
    }

    private void breakTreeSymmetries() throws IloException {
        int n = this.graph.vertexSet().size();
        for (Edge e : this.graph.edgeSet()) {
            Node from = this.graph.getEdgeSource(e);
            Node to = this.graph.getEdgeTarget(e);
            this.cplex.addLe(this.cplex.sum((IloNumExpr)this.d.get(from), this.cplex.prod((double)(n - 1), (IloNumExpr)this.w.get(e))), this.cplex.sum((double)n, (IloNumExpr)this.d.get(to)));
            this.cplex.addLe(this.cplex.sum((IloNumExpr)this.d.get(to), this.cplex.prod((double)(n - 1), (IloNumExpr)this.w.get(e))), this.cplex.sum((double)n, (IloNumExpr)this.d.get(from)));
        }
    }

    private void tighten() throws IloException {
        Blocks blocks = new Blocks(this.graph);
        Separator separator = new Separator(this.y, this.w, this.cplex, this.graph);
        separator.setMaxToAdd(this.maxToAddCuts);
        separator.setMinToConsider(this.considerCuts);
        if (blocks.cutpoints().contains(this.root)) {
            for (Set<Node> component : blocks.incidentBlocks(this.root)) {
                this.dfs(this.root, component, true, blocks, separator);
            }
        } else {
            this.dfs(this.root, blocks.componentOf(this.root), true, blocks, separator);
        }
        this.cplex.use((IloCplex.Callback)separator);
    }

    private void dfs(Node root, Set<Node> component, boolean fake, Blocks blocks, Separator separator) throws IloException {
        separator.addComponent(this.graph.subgraph(component), root);
        if (!fake) {
            for (Node node : component) {
                this.cplex.addLe(this.cplex.diff((IloNumExpr)this.y.get(node), (IloNumExpr)this.y.get(root)), 0.0);
            }
        }
        for (Edge e : this.graph.edgesOf(root)) {
            if (!component.contains(this.graph.opposite(root, e))) continue;
            this.cplex.addEq((IloNumExpr)this.getX(e, root), 0.0);
        }
        for (Node cp : blocks.cutpointsOf(component)) {
            if (root == cp) continue;
            for (Set<Node> comp : blocks.incidentBlocks(cp)) {
                if (comp == component) continue;
                this.dfs(cp, comp, false, blocks, separator);
            }
        }
    }

    @Override
    public boolean isSolvedToOptimality() {
        return this.isSolvedToOptimality;
    }

    private List<Elem> getResult() throws IloException {
        this.isSolvedToOptimality = false;
        ArrayList<Elem> result = new ArrayList<Elem>();
        for (Node node : this.graph.vertexSet()) {
            if (!(this.cplex.getValue(this.y.get(node)) > 0.01)) continue;
            result.add(node);
        }
        for (Edge edge : this.graph.edgeSet()) {
            if (!(this.cplex.getValue(this.w.get(edge)) > 0.01)) continue;
            result.add(edge);
        }
        if (this.cplex.getStatus() == IloCplex.Status.Optimal) {
            this.isSolvedToOptimality = true;
        }
        return result;
    }

    private void initVariables() throws IloException {
        this.y = new LinkedHashMap<Node, IloNumVar>();
        this.w = new LinkedHashMap<Edge, IloNumVar>();
        this.d = new LinkedHashMap<Node, IloNumVar>();
        this.x = new LinkedHashMap<Edge, Pair<IloNumVar, IloNumVar>>();
        this.x0 = new LinkedHashMap<Node, IloNumVar>();
        for (Node node : this.graph.vertexSet()) {
            String nodeName = Integer.toString(node.getNum() + 1);
            this.d.put(node, this.cplex.numVar(0.0, Double.MAX_VALUE, "d" + nodeName));
            this.y.put(node, (IloNumVar)this.cplex.boolVar("y" + nodeName));
            this.x0.put(node, (IloNumVar)this.cplex.boolVar("x_0_" + (node.getNum() + 1)));
        }
        for (Edge edge : this.graph.edgeSet()) {
            Node from = this.graph.getEdgeSource(edge);
            Node to = this.graph.getEdgeTarget(edge);
            String edgeName = from.getNum() + 1 + "_" + (to.getNum() + 1);
            this.w.put(edge, (IloNumVar)this.cplex.boolVar("w_" + edgeName));
            IloIntVar in = this.cplex.boolVar("x_" + edgeName + "_in");
            IloIntVar out = this.cplex.boolVar("x_" + edgeName + "_out");
            this.x.put(edge, new Pair<IloIntVar, IloIntVar>(in, out));
        }
    }

    private void tuning(IloCplex cplex) throws IloException {
        cplex.setParam(IloCplex.BooleanParam.PreInd, true);
        cplex.setParam(IloCplex.IntParam.Threads, this.threads);
        cplex.setParam(IloCplex.IntParam.ParallelMode, -1);
        cplex.setParam(IloCplex.DoubleParam.EpRHS, 1.0E-4);
        cplex.setParam(IloCplex.DoubleParam.EpInt, 1.0E-4);
        cplex.setParam(IloCplex.IntParam.MIPOrdType, 3);
        if (this.tl.getRemainingTime() <= 0.0) {
            cplex.setParam(IloCplex.DoubleParam.TiLim, 0.01);
        } else if (this.tl.getRemainingTime() != Double.POSITIVE_INFINITY) {
            cplex.setParam(IloCplex.DoubleParam.TiLim, this.tl.getRemainingTime());
        }
    }

    private void breakRootSymmetry() throws IloException {
        int n = this.graph.vertexSet().size();
        PriorityQueue<Node> nodes = new PriorityQueue<Node>(this.graph.vertexSet());
        int k = n;
        IloNumExpr[] terms = new IloNumExpr[n];
        IloNumExpr[] rs = new IloNumExpr[n];
        while (!nodes.isEmpty()) {
            Node node = nodes.poll();
            terms[k - 1] = this.cplex.prod((double)k, (IloNumExpr)this.x0.get(node));
            rs[k - 1] = this.cplex.prod((double)k, (IloNumExpr)this.y.get(node));
            --k;
        }
        IloNumVar sum = this.cplex.numVar(0.0, (double)n, "prSum");
        this.cplex.addEq((IloNumExpr)sum, this.cplex.sum(terms));
        for (int i = 0; i < n; ++i) {
            this.cplex.addGe((IloNumExpr)sum, rs[i]);
        }
    }

    private void addObjective() throws IloException {
        LinkedHashMap<Elem, IloNumVar> summands = new LinkedHashMap<Elem, IloNumVar>();
        LinkedHashSet<Elem> toConsider = new LinkedHashSet<Elem>();
        toConsider.addAll(this.graph.vertexSet());
        toConsider.addAll(this.graph.edgeSet());
        for (Elem elem : toConsider) {
            summands.put(elem, this.getVar(elem));
        }
        IloLinearNumExpr sum = this.unitScalProd(summands.keySet(), summands);
        this.cplex.addGe((IloNumExpr)sum, this.minimum);
        this.cplex.addMaximize((IloNumExpr)sum);
    }

    private IloNumVar getVar(Elem elem) {
        return elem instanceof Node ? this.y.get(elem) : this.w.get(elem);
    }

    @Override
    public void suppressOutput() {
        this.suppressOutput = true;
    }

    private void addConstraints() throws IloException {
        this.sumConstraints();
        this.otherConstraints();
        this.distanceConstraints();
    }

    private void distanceConstraints() throws IloException {
        int n = this.graph.vertexSet().size();
        for (Node v : this.graph.vertexSet()) {
            this.cplex.addLe((IloNumExpr)this.d.get(v), this.cplex.diff((double)n, this.cplex.prod((double)n, (IloNumExpr)this.x0.get(v))));
        }
        for (Edge e : this.graph.edgeSet()) {
            Node from = this.graph.getEdgeSource(e);
            Node to = this.graph.getEdgeTarget(e);
            this.addEdgeConstraints(e, from, to);
            this.addEdgeConstraints(e, to, from);
        }
    }

    private void addEdgeConstraints(Edge e, Node from, Node to) throws IloException {
        int n = this.graph.vertexSet().size();
        IloNumVar z = this.getX(e, to);
        this.cplex.addGe(this.cplex.sum((double)n, (IloNumExpr)this.d.get(to)), this.cplex.sum((IloNumExpr)this.d.get(from), this.cplex.prod((double)(n + 1), (IloNumExpr)z)));
        this.cplex.addLe(this.cplex.sum((IloNumExpr)this.d.get(to), this.cplex.prod((double)(n - 1), (IloNumExpr)z)), this.cplex.sum((IloNumExpr)this.d.get(from), (double)n));
    }

    private void maxSizeConstraints() throws IloException {
        for (Node v : this.graph.vertexSet()) {
            for (Node u : this.graph.neighborListOf(v)) {
                Edge e;
                if (!(u.getWeight() >= 0.0) || (e = this.graph.getEdge(v, u)) == null || !(e.getWeight() >= 0.0)) continue;
                this.cplex.addLe((IloNumExpr)this.y.get(v), (IloNumExpr)this.w.get(e));
            }
        }
    }

    private void otherConstraints() throws IloException {
        for (Edge edge : this.graph.edgeSet()) {
            Pair<IloNumVar, IloNumVar> arcs = this.x.get(edge);
            Node from = this.graph.getEdgeSource(edge);
            Node to = this.graph.getEdgeTarget(edge);
            this.cplex.addLe(this.cplex.sum((IloNumExpr)arcs.first, (IloNumExpr)arcs.second), (IloNumExpr)this.w.get(edge));
            this.cplex.addLe((IloNumExpr)this.w.get(edge), (IloNumExpr)this.y.get(from));
            this.cplex.addLe((IloNumExpr)this.w.get(edge), (IloNumExpr)this.y.get(to));
        }
    }

    private void sumConstraints() throws IloException {
        this.cplex.addLe(this.cplex.sum((IloNumExpr[])this.graph.vertexSet().stream().map(x -> this.x0.get(x)).toArray(IloNumVar[]::new)), 1.0);
        if (this.root != null) {
            this.cplex.addEq((IloNumExpr)this.x0.get(this.root), 1.0);
        }
        for (Node node : this.graph.vertexSet()) {
            Set<Edge> edges = this.graph.edgesOf(node);
            IloNumVar[] xSum = new IloNumVar[edges.size() + 1];
            int i = 0;
            for (Edge edge : edges) {
                xSum[i++] = this.getX(edge, node);
            }
            xSum[xSum.length - 1] = this.x0.get(node);
            this.cplex.addEq(this.cplex.sum((IloNumExpr[])xSum), (IloNumExpr)this.y.get(node));
        }
    }

    private IloNumVar getX(Edge e, Node to) {
        if (this.graph.getEdgeSource(e) == to) {
            return (IloNumVar)this.x.get((Object)e).first;
        }
        return (IloNumVar)this.x.get((Object)e).second;
    }

    private IloLinearNumExpr unitScalProd(Set<? extends Elem> units, Map<? extends Elem, IloNumVar> vars) throws IloException {
        int n = units.size();
        double[] coef = new double[n];
        IloNumVar[] variables = new IloNumVar[n];
        int i = 0;
        for (Elem elem : units) {
            coef[i] = elem.getWeight();
            variables[i++] = vars.get(elem);
        }
        return this.cplex.scalProd(coef, variables);
    }

    @Override
    public void setLB(double lb) {
        this.minimum = lb;
    }

    private /* synthetic */ boolean lambda$tryMstSolution$0(Set mstSol, Graph tree, Node cur, Set visitedNodes, Node node) {
        return mstSol.contains(node) || this.isGoodNode(node, tree.getEdge(cur, node), visitedNodes);
    }

    private class LogCallback
    extends IloCplex.IncumbentCallback {
        private LogCallback() {
        }

        protected void main() throws IloException {
            if (this.getSolutionSource() == 118) {
                System.out.println("MST Heuristic solution");
                System.out.println("Value " + this.getIncumbentObjValue());
            }
        }
    }

    private class MstCallback
    extends IloCplex.HeuristicCallback {
        private int counter;
        private IloVarHolder hld;

        MstCallback(int counter) {
            this.counter = counter;
            this.hld = new IloVarHolder(){

                @Override
                protected void setSolution(IloNumVar[] v, double[] d) throws IloException {
                    MstCallback.this.setSolution(v, d);
                }

                @Override
                protected double getValue(IloNumVar v) throws IloException {
                    return MstCallback.this.getValue(v);
                }
            };
        }

        protected void main() throws IloException {
            if (this.counter % 1000 == 0 && this.counter / 1000 < 10) {
                RLTSolver.this.tryMst(this.hld);
            }
            ++this.counter;
        }

        protected MstCallback clone() {
            return new MstCallback(this.counter);
        }
    }
}

