% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{mc_calc_vwc}
\alias{mc_calc_vwc}
\title{Calibrating TMS soil moisture from raw TMS to VWC}
\usage{
mc_calc_vwc(
  data,
  moist_sensor = .model_const_SENSOR_TMS_TMSmoisture,
  temp_sensor = .model_const_SENSOR_TMS_T1,
  output_sensor = "VWC_moisture",
  soiltype = "universal",
  localities = NULL,
  ref_t = .calib_MOIST_REF_T,
  acor_t = .calib_MOIST_ACOR_T,
  wcor_t = .calib_MOIST_WCOR_T,
  frozen2NA = TRUE
)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{moist_sensor}{name of soil moisture sensor to be converted from TMS
units to volumetric (default "TMS_TMSmoisture") see \code{names(mc_data_sensors)}.
Soil moisture sensor must be in TMSmoisture physical see \code{names(mc_data_physical)}.}

\item{temp_sensor}{name of soil temperature sensor (default "TMS_T1")
see \code{names(mc_data_sensors)}. Temperature sensor must be in T_C physical.}

\item{output_sensor}{name of new snow virtual sensor with VWC values (default "VWC_moisture")}

\item{soiltype}{value from \link{mc_data_vwc_parameters} in column soiltype
(default "universal").  Parameters a, b and c are used in calculation.}

\item{localities}{list of locality_ids for calculation; if NULL then all (default NULL)}

\item{ref_t}{(default 24)}

\item{acor_t}{(default 1.91132689118083) correction temperature while
sensor on the air see \code{\link[=mc_calib_moisture]{mc_calib_moisture()}}}

\item{wcor_t}{(default 0.64108) correction temperature while
sensor in the water \code{\link[=mc_calib_moisture]{mc_calib_moisture()}}}

\item{frozen2NA}{if TRUE then those moisture records are set to
NA when soil temperature is below 0 (default TRUE)}
}
\value{
myClim object same as input but with added virtual VWC moisture sensor
}
\description{
This function creates new virtual sensor on locality within myClim data object.
Function converts the soil moisture from raw TMS units (scaled TDT signal)
to volumetric water content (VWC).
}
\details{
This function is suitable for Tomst TMS loggers measuring soil moisture in raw TDT
units (TMS units). Raw TDT units represents inverted and scaled (1-4095)
number of high frequency-shaped electromagnetic pulses (ca 2.5 GHz)
sent through a ca 30 cm long circuit within a 640-microsecond time window.
For more details see (Wild et al. 2019). Pulse count is directly related to
the soil moisture content. Therefore, based on experimental calibration
curves, it is possible to directly convert TMS units to standardized
volumetric water content in cubic meters. For more details see (Kopecky et al. 2021).

The function uses experimentally derived calibration curves under
reference temperatures for several soil types. For the volumetric
water content conversion the reference temperature is corrected with the
actual soil temperature using TMS_T1 soil temperature sensor records.
As the calibration curves were derived for several soil types,
in case user know specific soil type, where the logger was measuring,
then it is strongly recommended to chose the closest
existing calibration curve for specific soil type instead of default "universal".
Available soil types are: sand, loamy sand A, loamy sand B, sandy loam A,
sandy loam B, loam, silt loam, peat, water, #' universal, sand TMS1,
loamy sand TMS1, silt loam TMS1. For more details see (Wild et al. 2019).
For full table of function parameters see \link{mc_data_vwc_parameters}

The function by default replace the moisture records in frozen soils with NA,
because the soil moisture sensor was not designed to measure in
frozen soils and the returned records are thus not comparable
with values from non-frozen soil.
}
\examples{
agg_data <- mc_calc_vwc(mc_data_example_agg, soiltype="sand", localities="A2E32")
}
\references{
Wild, J., Kopecky, M., Macek, M., Sanda, M., Jankovec, J., Haase, T., 2019. Climate at ecologically relevant scales:
A new temperature and soil moisture logger for long-term microclimate measurement. Agric. For. Meteorol. 268, 40-47.
https://doi.org/10.1016/j.agrformet.2018.12.018

Kopecky, M., Macek, M., Wild, J., 2021. Topographic Wetness Index calculation guidelines based on measured soil
moisture and plant species composition. Sci. Total Environ. 757, 143785. https://doi.org/10.1016/j.scitotenv.2020.143785
}
\seealso{
\link{mc_data_vwc_parameters}
}
