% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{mc_join}
\alias{mc_join}
\title{Joining time-series from repeated downloads}
\usage{
mc_join(data, comp_sensors = NULL)
}
\arguments{
\item{data}{myClim object in Raw-format. see \link{myClim-package}}

\item{comp_sensors}{senors for compare and select source logger; If NULL then first is used. (default NULL)}
}
\value{
myClim object with joined loggers.
}
\description{
Function join time-series from repeated download on the same locality.
If time-series overlaps and values are identical or first and last
records fit, then automatically joined without any user action.
If values are different on overlap, then user interactively selects
which source logger to use.
Description of conflict and interactive line plots with conflict intervals
are shown during joining of each logger one-by-one.
}
\details{
Joining is semi-automatic pairwise process.
In case the end of older and start of the newer time-series fits
myClim is sequentially adding the newer time-series to the older without
any user action. In case the time series overlap and values on the
overlap are not identical, user interactively selects which
time series to use or type in the specific datetime where to trim
older time-series and continue newer. To support joining interactive lines
and text description of conflict time-series are shown.
User can zoom in/out the plot and with mouse identify
specific datetime where to trim older series and continue newer.

Loggers with multiple sensors are joined base on one or more selected sensors.
See parameter \code{comp_sensors}.

Name of resulting joined sensor is used from logger with the oldest data. If \code{serial_number}
is not equal while joining loggers, then the resulting \code{serial_number} is \code{NA}.
Clean info is changed to \code{NA} except step. In case you are joining not calibrated
sensor with calibrated one, then calibration information must be empty in not calibrated sensor.
}
