## ---- echo = FALSE, message = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(myTAI)
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # install biomartr from CRAN
#  install.packages("biomartr",
#                   repos        = "https://cran.rstudio.com/",
#                   dependencies = TRUE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # download the proteome of Arabidopsis thaliana from refseq
#  # and store the corresponding proteome file in '_ncbi_downloads/proteomes'
#  getProteome( db       = "refseq",
#               kingdom  = "plant",
#               organism = "Arabidopsis thaliana",
#               path     = file.path("_ncbi_downloads","proteomes") )

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # path to proteome: '_ncbi_downloads/proteomes/Arabidopsis_thaliana_protein.faa.gz'
#  file_path <- file.path("_ncbi_downloads","proteomes","Arabidopsis_thaliana_protein.faa.gz")
#  # read proteome as data.table object
#  Ath_proteome <- read_proteome(file_path, format = "fasta")

## ----eval =FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(myTAI)
#  
#  data(PhyloExpressionSetExample)
#  
#  # category-centered visualization of PS specific expression level distributions (log-scale)
#  PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
#                   legendName    = "PS",
#                   test.stat     = TRUE,
#                   type          = "category-centered",
#                   distr.type    = "boxplot",
#                   log.expr      = TRUE)

## ----eval =FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(myTAI)
#  
#  data(PhyloExpressionSetExample)
#  
#  # stage-centered visualization of PS specific expression level distributions (log-scale)
#  PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
#                   legendName    = "PS",
#                   test.stat     = TRUE,
#                   type          = "stage-centered",
#                   distr.type    = "boxplot",
#                   log.expr      = TRUE)

## ----eval =FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(PhyloExpressionSetExample)
#  
#  # category-centered visualization of PS specific expression level distributions (log-scale)
#  PlotCategoryExpr(ExpressionSet = tf(PhyloExpressionSetExample, log2),
#                   legendName    = "PS",
#                   test.stat     = TRUE,
#                   type          = "category-centered",
#                   distr.type    = "boxplot",
#                   log.expr      = FALSE)

## ----eval =FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(PhyloExpressionSetExample)
#  
#  # category-centered visualization of PS specific expression level distributions (sqrt-scale)
#  PlotCategoryExpr(ExpressionSet = tf(PhyloExpressionSetExample, sqrt),
#                   legendName    = "PS",
#                   test.stat     = TRUE,
#                   type          = "category-centered",
#                   distr.type    = "boxplot",
#                   log.expr      = FALSE)

## ----eval =FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(PhyloExpressionSetExample)
#  
#  # define an example gene subset (500 genes) which
#  # can be found in the input ExpressionSet
#  set.seed(234)
#  example.gene.set <- PhyloExpressionSetExample[sample(1:25260,500) , 2]
#  
#  # visualize the gene expression distributions for these 500 genes (category-centered)
#  PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
#                   legendName    = "PS",
#                   test.stat     = TRUE,
#                   type          = "category-centered",
#                   distr.type    = "boxplot",
#                   log.expr      = TRUE,
#                   gene.set      = example.gene.set)

## ----eval =FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(PhyloExpressionSetExample)
#  
#  # define an example gene subset (500 genes) which
#  # can be found in the input ExpressionSet
#  set.seed(234)
#  example.gene.set <- PhyloExpressionSetExample[sample(1:25260,500) , 2]
#  
#  # visualize the gene expression distributions for these 500 genes (stage-centered)
#  PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
#                   legendName    = "PS",
#                   test.stat     = TRUE,
#                   type          = "stage-centered",
#                   distr.type    = "boxplot",
#                   log.expr      = TRUE,
#                   gene.set      = example.gene.set)

