% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotCategoryExpr.R
\name{PlotCategoryExpr}
\alias{PlotCategoryExpr}
\title{Plot the Expression Levels of each Age or Divergence Category as Boxplot, Violinplot, or Dotplot}
\usage{
PlotCategoryExpr(ExpressionSet, legendName, test.stat = TRUE,
  type = "category-centered", distr.type = "boxplot",
  log.expr = FALSE, gene.set = NULL)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{legendName}{a character string specifying whether "PS" or "DS" are used to compute relative expression profiles.}

\item{test.stat}{a logical value indicating whether a Benjamini-Hochberg adjusted \code{\link{kruskal.test}} should be applied to determine
significant differences in age or divergence category specific expression.}

\item{type}{type of age or divergence category comparison. Specifications can be \code{type = "category-centered"} or \code{type = "stage-centered"}.}

\item{distr.type}{format of visualizing age or divergence category specific expression distributions. Either \code{distr.type = "boxplot"}, \code{distr.type = "dotplot"}, or
\code{distr.type = "violin"}.}

\item{log.expr}{a logical value specifying whether or not expression levels should internally be log2-transformed before visualization.}

\item{gene.set}{a character vector storing the gene ids for which gene expression levels shall be visualized.}
}
\value{
A boxplot, violin plot, or dot plot visualizing the gene expression levels of
different PS or DS categories.

Furthermore, the statistical test results returned from the \code{\link{kruskal.test}} are printed
to the console.

(1) '*'   = P-Value <= 0.05 

(2) '**'  = P-Value <= 0.005  

(3) '***' = P-Value <= 0.0005  

(4) 'n.s.' = not significant = P-Value > 0.05
}
\description{
This function visualizes the expression level distribution of each phylostratum during each time point or experiment
as boxplot, dot plot, or violin plot enabling users to quantify the age (PS) or divergence (DS) category specific contribution to the
corresponding transcriptome.
}
\details{
This way of visualizing the gene expression distribution of each age (PS) or divergence (DS) category during
all developmental stages or experiments allows users to detect specific age or divergence categories contributing significant
levels of gene expression to the underlying biological process (transcriptome).

This quantification allows users to conclude that genes originating in specific PS or DS contribute significantly more to the overall transcriptome
than other genes originating from different PS or DS categories. More specialized analyses such as \code{\link{PlotMeans}}, \code{\link{PlotRE}},
\code{\link{PlotBarRE}}, etc. will then allow to study the exact mean expression patterns of these age or divergence categories.

The statistical quantification of differences between expression levels of different age or divergence categories
is done by performing a \code{\link{kruskal.test}} with Benjamini & Hochberg p-value adjustment for multiple comparisons.

\itemize{
\item \code{type = "category-centered"} Here, the \code{\link{kruskal.test}} quantifies the differences of gene expression between all combinations of age or divergence categories for each stage or experiment separately. Here, a significant p-value quantifies that there is at least one pairwise comparison for which age or divergence categories significantly differ in their gene expression distribution. This type of analysis allows users to detect stages or experiments that show high diviation between age or divergence category contributions to the overall transcriptome or no significant deviations of age or divergence categories, suggesting equal age or divergence category contributions to the overall transcriptome.   
\item \code{type = "stage-centered"} Here, the \code{\link{kruskal.test}} quantifies the differences of gene expression between all stages or experiments for each age or divergence category separately. Hence, the test quantifies whether or not the gene expression distribution of a single age or divergence category significantly changes throughout development or experiments. This type of analysis allows users to detect specific age or divergence categories that significantly change their expression levels throughout development or experiments.
}

Argument Specifications:

Argument: type

\itemize{
\item \code{type = "category-centered"} This specification allows users to compare the differences between all age or
 divergence categories during the same stage or experiment.
 \item \code{type = "stage-centered"} This specification allows users to compare the differences between all age or
 divergence categories between stages or experiments.
}

  
Argument: distr.type

\itemize{
\item \code{distr.type = "boxplot"} This specification allows users to visualize the expression distribution of all PS or DS as boxplot.
\item \code{distr.type = "violin"} This specification allows users to visualize the expression distribution of all PS or DS as violin plot.
\item \code{distr.type = "dotplot"} This specification allows users to visualize the expression distribution of all PS or DS as dot plot.
}


Finally, users can specify a \code{gene.set} (a subset of genes included in the input \code{ExpressioSet})
for which expression levels should be visualized as boxplot, dotplot, or violinplot.
}
\examples{

data(PhyloExpressionSetExample)
data(DivergenceExpressionSetExample)

\dontrun{

# category-centered visualization of PS specific expression level distributions (log-scale)
PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
                     legendName    = "PS",
                     test.stat     = TRUE,
                     type          = "category-centered",
                     distr.type    = "boxplot",
                     log.expr      = TRUE)
                     

# stage-centered visualization of PS specific expression level distributions (log-scale)
PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
                     legendName    = "PS",
                     test.stat     = TRUE,
                     distr.type    = "boxplot",
                     type          = "stage-centered",
                     log.expr      = TRUE)

                     
                                                               
# category-centered visualization of PS specific expression level distributions (log-scale)
# as violoin plot
PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
                     legendName    = "PS",
                     test.stat     = TRUE,
                     distr.type    = "violin",
                     type          = "stage-centered",
                     log.expr      = TRUE)




# analogous for DivergenceExpressionSets
PlotCategoryExpr(ExpressionSet = DivergenceExpressionSetExample,
                     legendName    = "DS",
                     test.stat     = TRUE,
                     type          = "category-centered",
                     distr.type    = "boxplot",
                     log.expr      = TRUE)


# visualize the expression levels of 500 example genes
set.seed(234)
example.gene.set <- PhyloExpressionSetExample[sample(1:25260,500) , 2]

PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
                 legendName    = "PS",
                 test.stat     = TRUE,
                 type          = "category-centered",
                 distr.type    = "boxplot",
                 log.expr      = TRUE,
                 gene.set      = example.gene.set)
                 
}
}
\seealso{
\code{\link{PlotMeans}}, \code{\link{PlotRE}}, \code{\link{PlotBarRE}}, \code{\link{age.apply}},
\code{\link{pTAI}}, \code{\link{pTDI}}, \code{\link{pStrata}}, \code{\link{pMatrix}}, \code{\link{TAI}}, \code{\link{TDI}}
}
\author{
Hajk-Georg Drost
}
