% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotCIRatio.R
\name{PlotCIRatio}
\alias{PlotCIRatio}
\title{Plot Transcriptome Index using bootstrapping and confidence intervals}
\usage{
PlotCIRatio(ExpressionSet, measure, nbootstraps)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet, DivergenceExpressionSet or PolymorphismsExpressionSet object.}

\item{measure}{type of transcriptome index that shall be computed. E.g. measure = "TAI" (Transcriptome Age Index), measure = "TDI" (Transcriptome Divergence Index), measure = "TPI" (Transcriptome Polymorphism Index).}

\item{nbootstraps}{number of independent bootstraps.}
}
\description{
Function to plot and compare the confidence intervals of Transcriptome Index between transformed and non-transformed expression data 
by using bootstrapping appraoches instead of permutation tests used in \code{\link{PlotSignature}}.
}
\details{
This function can be used to check potential outliers (e.g. a few exramly highly expressed genes) in transcriptome. 
Since Transcriptome Index is weigthed mean, it could be easily affectd by outliers. So, we have to check potential outliers in the transcriptome data.
Because log or sqrt trandformation can alleviate the effect of outliers, if there are some outliers, we could see the confidence intervals (genetated by bootstrapping) 
from non-trandformed expression data are much higher and more variable than from log or sqrt trandformed expression data.
In order to compare the range of confidence intervals in the same scale, we plotted the ratio of upper to lower confidence interval boundary across development.
}
\examples{
data("PhyloExpressionSetExample")
PlotCIRatio(PhyloExpressionSetExample,"TAI",5)
}
\seealso{
\code{\link{PlotSignature}}
}
\author{
Jialin Liu
}
