% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_late_conservation_test.R
\name{stat_late_conservation_test}
\alias{stat_late_conservation_test}
\title{Late Conservation Test}
\usage{
stat_late_conservation_test(phyex_set, modules, ...)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{modules}{A named list with elements 'early', 'mid', and 'late' containing
stage indices for each developmental module}

\item{...}{Additional arguments passed to stat_generic_conservation_test}
}
\value{
A ConservationTestResult object with late conservation test results
}
\description{
Test for late conservation patterns in transcriptomic data by comparing
late developmental stages to early and mid stages.
}
\details{
The late conservation test evaluates whether later developmental stages show
lower transcriptomic index values (indicating older genes) compared to earlier
stages. The test computes a score based on the minimum difference between
early vs. late and mid vs. late TXI values.
}
\examples{
# Define developmental modules
modules <- list(early = 1:2, mid = 3:5, late = 6:7)
result <- stat_late_conservation_test(example_phyex_set_old, modules)

}
\seealso{
\code{\link{stat_generic_conservation_test}}, \code{\link{stat_early_conservation_test}}
}
