\name{nScree}
\alias{nScree}
\title{ Non Graphical Cattel's Scree Test}

\description{
 The \emph{nScree} function returns an analysis of the number of factors to retain in an exploratory 
 principal components analysis. The function also return informations about the number of factors to retain with the Kaiser-Guttman 
 rule and the parallel analysis. 
 }

\usage{
 nScree(eig,
        aparallel = rep(1, length(eig)))
 }

\arguments{
  \item{eig}{       numeric: Eigenvalues to analyse }
  \item{aparallel}{ numeric: Results of a parallel analysis (default eigenvalues fixed at 1.00 - the Kaiser-Guttman rule) }
 }

\details{
 The \emph{nScree} function returns an analysis of the number of factors to retain in an exploratory 
 principal components analysis. Different solutions are given. The classical ones are the Kaiser-Guttman rule, 
 the parallel analysis, and the usual scree test (\code{\link{plotuScree}}). 
 Non graphical solutions to the Cattell subjective scree test are also proposed: 
 an acceleration factor and the optimal coordinates index. The acceleration factor indicates where the 
 elbow of the scree plot appears. It corresponds to the acceleration of the curve, i.e. the second derivative. 
 The optimal coordinates are the extrapolated coordinates of the previous eigenvalue that let the observed eigenvalue 
 be over this extrapolation. The extrapolation is made by a linear regression using the last eigenvalue 
 coordinates and the k+1 eigenvalue coordinates. There are k-2 regression lines like this. Would it be fot the 
 acceleration factor, or for the optimal coordinates, the Kaiser-Guttman rule or a parallel analysis criterion (\code{\link{parallel}}) 
 must also be simultaneously satisfied to retain the components.
 
 If \eqn{\lambda_i} is the \eqn{i^{th}} eigenvalue, and \eqn{LS_i} is a location statistics like the mean or a centile 
 (generally the following: \eqn{1^{st}, \ 5^{th}, \ 95^{th}, \ or \ 99^{th}}).
 
 The Kaiser-Guttman rule is computed as: 
  \deqn{ n_{Kaiser-Guttman} = \sum_{i} (\lambda_{i} \ge 1.00).}
 
 The parallel analysis is computed as: 
  \deqn{n_{parallel} = \sum_{i} (\lambda_{i} \ge LS_i).}
 
 The acceleration factor (\eqn{AF}) corresponds to a numeral solution to the elbow of the scree plot:
   \deqn{n_{AF} \equiv \ IF \ \left[  (\lambda_{i} \ge LS_i) \ and \ max(AF_i) \right].}
   
 The optimal coordinates (\eqn{OC}) corresponds to an extrapolation of the preceding eigenvalue by a regression 
 line between the eignvalue coordinates and the last eigenvalue coordinate:
   \deqn{n_{OC} = \sum_i \left[(\lambda_i \ge LS_i) \cap (\lambda_i \ge (\lambda_{i \ predicted}) \right].}    
 }

\value{
  \item{Components }{              Data frame for the number of components according to different rules }
  \item{Components$noc }{          Number of factors to retain according to optimal coordinates }
  \item{Components$naf }{          Number of factors to retain according to the acceleration factor }
  \item{Components$npar.analysis }{Number of factors to retain according to parallel analysis }
  \item{Components$nkaiser }{      Number of factors to retain according to the Kaiser-Guttman rule }
  \item{Analysis }{                Data frame of vectors linked to the different rules }
  \item{Analysis$Eigenvalues }{    Eigenvalues }
  \item{Analysis$Prop }{           Proportion of variance accounted by eigenvalues }  
  \item{Analysis$Cumu }{           Cumulative proportion of variance accounted by eigenvalues }  
  \item{Analysis$Par.Analysis }{   Centiles of the random eigenvalues generated by the parallel analysis. }
  \item{Analysis$Pred.eig }{       Predicted eigenvalues by each optimal coordinate regression line }
  \item{Analysis$OC}{              Critical optimal coordinates }  
  \item{Analysis$Acc.factor }{     Acceleration factor }
  \item{Analysis$AF}{              Critical acceleration factor }    
  Otherwise, returns a summary of the analysis.
 }

\seealso{
 \code{\link{plotuScree}}, 
 \code{\link{plotnScree}},
 \code{\link{parallel}},
 \code{\link{plotParallel}},  
 }

\references{ 
 Cattell, R. B. (1966). The scree test for the number of factors. \emph{Multivariate Behavioral Research, 1}, 245-276.

 Guttman, L. (1954). Some necessary conditions for common factor analysis. \emph{Psychometrika, 19, 149-162}.

 Horn, J. L. (965). A rationale for the number of factors in factor analysis. \emph{Psychometrika, 30}, 179-185.

 Kaiser, H. F. (1960). The application of electronic computer to factor analysis. \emph{Educational and Psychological
 Measurement, 20}, 141-151.

 Raiche, G., Riopel, M. and Blais, J.-G. (2006). \emph{Non graphical solutions for the Cattell's scree test}.
 Paper presented at the International Annual meeting of the Psychometric Society, Montreal.
 [\url{http://www.er.uqam.ca/nobel/r17165/RECHERCHE/COMMUNICATIONS/}]
 }

\author{ 
    Gilles Raiche, Universite du Quebec a Montreal
    \email{raiche.gilles@uqam.ca}, \url{http://www.er.uqam.ca/nobel/r17165/}
}

\examples{
## INITIALISATION
 data(dFactors)                      # Load the nFactors dataset
 attach(dFactors)
 vect         <- Raiche              # Use the example from Raiche
 eigenvalues  <- vect$eigenvalues    # Extract the observed eigenvalues
 nsubjects    <- vect$nsubjects      # Extract the number of subjects
 variables    <- length(eigenvalues) # Compute the number of variables
 rep          <- 100                 # Number of replications for the parallel analysis
 cent         <- 0.95                # Centile value of the parallel analysis

## PARALLEL ANALYSIS (qevpea for the centile criterion, mevpea for the mean criterion)
 aparallel    <- parallel(var     = variables,
                          subject = nsubjects, 
                          rep     = rep, 
                          cent    = cent
                          )$eigen$qevpea  # The 95 centile

## NOMBER OF FACTORS RETAINED ACCORDING TO DIFFERENT RULES 
 results <- nScree(eig       = eigenvalues,
                   aparallel = aparallel
                   )
                   
 results
 
## PLOT ACCORDING TO THE nScree CLASS 
 plotnScree(results)


## RESULTS OF THE nSree FUNCTION: AN EXAMPLE
## RESULTS CAN VARY ACCORDING TO RANDOM SIMULATION IN PARALLEL ANALYSIS

# $Components
#   noc naf nparallel nkeyser
# 1   2   1         2       5

# $Analysis
#    Eigenvalues        Prop      Cumu Par.Analysis  Pred.eig     OC Acc.factor     AF
# 1         5.54 0.369333333 0.3693333    2.8807740 2.6461538                NA (< AF)
# 2         2.46 0.164000000 0.5333333    2.3570618 1.9575000 (< OC)       2.43       
# 3         1.81 0.120666667 0.6540000    2.0132405 1.4690909              0.19       
# 4         1.35 0.090000000 0.7440000    1.7117006 1.0960000              0.11       
# 5         1.00 0.066666667 0.8106667    1.5115951 0.7400000              0.02       
# 6         0.67 0.044666667 0.8553333    1.3196573 0.6025000              0.20       
# 7         0.54 0.036000000 0.8913333    1.1188151 0.4857143              0.02       
# 8         0.43 0.028666667 0.9200000    0.9552613 0.3900000              0.02       
# 9         0.34 0.022666667 0.9426667    0.8249083 0.3640000              0.06       
# 10        0.31 0.020666667 0.9633333    0.6714989 0.2275000             -0.09       
# 11        0.19 0.012666667 0.9760000    0.5814073 0.1866667              0.08       
# 12        0.15 0.010000000 0.9860000    0.4473462 0.1450000              0.00       
# 13        0.11 0.007333333 0.9933333    0.3451530 0.0800000             -0.01       
# 14        0.06 0.004000000 0.9973333    0.2622424        NA              0.03       
# 15        0.04 0.002666667 1.0000000    0.1722911        NA                NA       

 }

\keyword{ multivariate }

