% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{SpreadSpecific}
\alias{SpreadSpecific}
\title{Get the best \emph{spread} of numbers in an interval.}
\usage{
SpreadSpecific(interval, specific, n, log = FALSE)
}
\arguments{
\item{interval}{A length 2 numeric vector. The real interval over which one
wants to spread the numbers.}

\item{specific}{A numeric vector. The specific numbers that one wants to be
part of our spread.}

\item{n}{A number. The total number of numbers that you want to be in the
spread (including the number(s) in \code{specific}).}

\item{log}{Measure the difference between adjacent elements as the difference
in their log instead?}
}
\value{
A numeric vector. The chosen \eqn{n} numbers.
}
\description{
Say we have an interval \eqn{[a, b]}  and we want to evenly spread \eqn{n}
numbers in this interval, however \eqn{m} of these \eqn{n} numbers have been
chosen beforehand, so we have to fithe the other \eqn{n - m} in around them
the best we can. Our goal is to maximize the minimum distance between
adjacent elements.
}
\details{
The idea is to, for an interval of size \eqn{s}, put in \eqn{floor(s / (n -
m))} numbers into each of these intervals. Then, if there any numbers left
over, put exactly one into each of the intervals with the biggest \eqn{(s /
(n - m)) - `floor`(s / (n - m))} (starting with the biggest and working
one's way down) until there are no numbers left to assign. The end intervals
need special treatment since (assuming the ends are not in the specific
numbers), the end intervals are open on one side (one boundary has no point
on it), whereas all the middle intervals are not.
}
\examples{
SpreadSpecific(c(0, 10), 1, 3)

}
