% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brightness.R
\name{brightness}
\alias{brightness}
\title{Calculate brightness from image series.}
\usage{
brightness(img, def, tau = NULL, thresh = NULL, filt = NULL,
  correct = FALSE, s = 1, offset = 0, readout_noise = 0,
  parallel = FALSE)
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}

\item{def}{A character. Which definition of brightness do you want to use,
\code{"B"} or \code{"epsilon"}?}

\item{tau}{The \eqn{tau} parameter for \emph{exponential filtering} detrending.
This must be a positive number. Set this to "auto" to use Nolan's algorithm
to automatically find a suitable value for this parameter (recommended).
For multi-channel images, it is possible to have a different \code{tau} for each
channel by specifying \code{tau} as a vector or list.}

\item{thresh}{The threshold or thresholding method (see
\code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}}) to use on the image prior to
detrending and brightness calculations.}

\item{filt}{Do you want to smooth (\code{filt = 'mean'}) or median (\code{filt = 'median'}) filter the number image using \code{\link[=smooth_filter]{smooth_filter()}} or
\code{\link[=median_filter]{median_filter()}} respectively? If selected, these are invoked here with a
filter radius of 1 (with corners included, so each median is the median of
9 elements) and with the option \code{na_count = TRUE}. If you want to
smooth/median filter the number image in a different way, first calculate
the numbers without filtering (\code{filt = NULL}) using this function and then
perform your desired filtering routine on the result.}

\item{correct}{Apply the number/brightness correction detailed in equation 7
of Hur et al. (2014). This is another correction for the effects of
bleaching and is needed in addition to the more conventional correction
controlled by the \code{tau} parameter.}

\item{s}{A number. The \eqn{S}-factor of microscope acquisition.}

\item{offset}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{readout_noise}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\value{
A matrix, the brightness image.
}
\description{
Given a time stack of images, \code{brightness()} performs a calculation of the
brightness for each pixel.
}
\examples{
img <- ijtiff::read_tif(system.file('extdata', '50.tif', package = 'nandb'))
ijtiff::display(img[, , 1, 1])
b <- brightness(img, "e", tau = NA, thresh = "Huang")
b <- brightness(img, "B", tau = 10, thresh = "tri")
}
\references{
Digman MA, Dalal R, Horwitz AF, Gratton E. Mapping the Number of
Molecules and Brightness in the Laser Scanning Microscope. Biophysical
Journal. 2008;94(6):2320-2332. \doi{10.1529/biophysj.107.114645}.

Dalal, RB, Digman, MA, Horwitz, AF, Vetri, V, Gratton, E (2008).
Determination of particle number and brightness using a laser scanning
confocal microscope operating in the analog mode. Microsc. Res. Tech., 71,
1:69-81. \doi{10.1002/jemt.20526}.

Hur K-H, Macdonald PJ, Berk S, Angert CI, Chen Y, Mueller JD (2014)
Quantitative Measurement of Brightness from Living Cells in the Presence of
Photodepletion. PLoS ONE 9(5): e97440. \doi{10.1371/journal.pone.0097440}.
}
