% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{context}
\alias{context}
\title{Open Context}
\usage{
context(socket)
}
\arguments{
\item{socket}{a Socket or nano object.}
}
\value{
A new Context (object of class 'nanoContext' and 'nano').
}
\description{
Open a new Context to be used with a Socket. The purpose of a Context is to
    permit applications to share a single socket, with its underlying dialers
    and listeners, while still benefiting from separate state tracking.
}
\details{
For convenience, this function may be called on a nano object as well
    as a socket, in which case it is the equivalent of calling the function
    on the object's socket directly.

    Contexts allow the independent and concurrent use of stateful
    operations using the same socket. For example, two different contexts
    created on a rep socket can each receive requests, and send replies to
    them, without any regard to or interference with each other.

    Note: not every protocol supports creation of separate contexts.

    To send and receive over a context use \code{\link{ctx_send}} or
    \code{\link{ctx_send_vec}} and \code{\link{ctx_recv}} or
    \code{\link{ctx_recv_vec}} respectively.
}
\examples{
s <- socket("req", listen = "inproc://nanonext")
ctx <- context(s)
ctx
close(ctx)
close(s)

n <- nano("req", listen = "inproc://nanonext")
ctx <- context(n)
ctx
close(ctx)
n$socket_close()

}
