% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{recv_ctx}
\alias{recv_ctx}
\title{Receive over Context}
\usage{
recv_ctx(
  context,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw"),
  timeout,
  keep.raw = TRUE
)
}
\arguments{
\item{context}{a Context.}

\item{mode}{[default 'serial'] mode of vector to be received - one of 'serial',
'character', 'complex', 'double', 'integer', 'logical', 'numeric', or 'raw'.
The default 'serial' means a serialised R object, for the other modes,
the raw vector received will be converted into the respective mode.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}

\item{keep.raw}{[default TRUE] logical flag whether to keep the received raw
vector (useful for verification e.g. via hashing). If FALSE, will return
the converted data only.}
}
\value{
Named list of 2 elements: 'raw' containing the received raw vector
    and 'data' containing the converted object, or else the converted object
    if 'keep.raw' is set to FALSE.
}
\description{
Receive data over a Context.
}
\details{
Will block while awaiting the receive operation to complete.
    Set a timeout to ensure that the function returns under all scenarios.

    In case of an error, an integer 'errorValue' is returned (to be
    distiguishable from an integer message value). This can be verified using
    \code{\link{is_error_value}}.

    If the raw data was successfully received but an error occurred in
    unserialisation or data conversion (for example if the incorrect mode was
    specified), the received raw vector will always be returned to allow for
    the data to be recovered.
}
\examples{
req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctxq <- context(req)
ctxp <- context(rep)
send_ctx(ctxq, data.frame(a = 1, b = 2), timeout = 100)
recv_ctx(ctxp, timeout = 100)

send_ctx(ctxq, c(1.1, 2.2, 3.3), mode = "raw", timeout = 100)
recv_ctx(ctxp, mode = "double", timeout = 100)

close(req)
close(rep)

}
