% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{transact}
\alias{transact}
\title{ncurl Transact}
\usage{
transact(session)
}
\arguments{
\item{session}{an 'ncurlSession' object.}
}
\value{
Named list of 4 elements:
    \itemize{
    \item{\code{$status}} {- integer HTTP repsonse status code (200 - OK).
    Use \code{\link{status_code}} for a translation of the meaning.}
    \item{\code{$headers}} {- named list of response headers (if specified in
    the session), or NULL otherwise. If the status code is within the 300
    range, i.e. a redirect, the response header 'Location' is automatically
    appended to return the redirect address.}
    \item{\code{$raw}} {- raw vector of the received resource (use
    \code{\link{writeBin}} to save to a file).}
    \item{\code{$data}} {- converted character string (if specified in the
    session), or NULL otherwise. This may be further parsed this as html,
    json, xml etc. if required.}
    }
}
\description{
nano cURL - a minimalist http(s) client. Transact once over the connection
    and stored parameters in an ncurl Session created with
    \code{\link{ncurl_session}}.
}
\examples{
s <- tryCatch(ncurl_session("https://httpbin.org/get"), error = identity)
if (!inherits(s, "error")) transact(s)

}
