% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_pools.R
\name{normalize_pools}
\alias{normalize_pools}
\title{Normalize data using common pools}
\usage{
normalize_pools(x, ref, x_pools, ref_pools, p = 3, weigh = TRUE)
}
\arguments{
\item{x}{target data}

\item{ref}{reference data}

\item{x_pools}{target pool samples}

\item{ref_pools}{reference pool samples}

\item{p}{number of pool sample sets. Defaults to 3.}

\item{weigh}{logical; if \code{TRUE}, the average expression in \code{x_pools} is
reweighed by the distribution of the \code{p} pool sample sets in \code{ref_pools}.}
}
\value{
normalized gene expression
}
\description{
Normalize nanostring gene expression using common pools between two CodeSets.
}
\details{
The target and reference expression samples, as well the target and reference
pool samples all need to be specified. We recommend reweighing the target
pool samples when calculating the average expression by the distribution of
reference pools.
}
\author{
Derek Chiu
}
