% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nauf_glm.R
\name{nauf_glm}
\alias{nauf_glm}
\alias{nauf_glm.nb}
\alias{nauf_lm}
\title{Fit a fixed effects regression using \code{nauf} contrasts.}
\usage{
nauf_glm(formula, family = gaussian, data = NULL, weights, subset,
  na.action = na.pass, start = NULL, etastart, mustart, offset,
  control = list(...), model = TRUE, method = "glm.fit", x = TRUE,
  y = TRUE, contrasts = NULL, ncs_scale = attr(formula,
  "standardized.scale"), ...)

nauf_lm(formula, data = NULL, subset, weights, na.action = na.pass,
  method = "qr", model = TRUE, x = TRUE, y = TRUE, qr = TRUE,
  singular.ok = TRUE, contrasts = NULL, offset, ncs_scale = attr(formula,
  "standardized.scale"), ...)

nauf_glm.nb(formula, data = NULL, weights, subset, na.action = na.pass,
  start = NULL, etastart, mustart, control = stats::glm.control(...),
  method = "glm.fit", model = TRUE, x = TRUE, y = TRUE,
  contrasts = NULL, ncs_scale = attr(formula, "standardized.scale"), ...,
  init.theta, link = log)
}
\arguments{
\item{formula, data, subset, offset, weights, method, control, start, etastart, mustart, qr, singular.ok, family, init.theta, link, ...}{See
\code{\link[stats]{lm}}, \code{\link[stats]{glm}}, and
\code{\link[MASS]{glm.nb}}.}

\item{na.action, contrasts}{Changes to the default values for these arguments
are ignored with a warning.  See \code{\link{nauf_model.frame}}.}

\item{model, x, y}{Chages to the default values for these arguments are ignored
with a warning.  See 'Details'.}

\item{ncs_scale}{A positive number to be passed as the \code{scale} argument
to \code{\link[standardize]{named_contr_sum}} for all unordered factors.
See \code{\link{nauf_model.frame}}.}
}
\value{
A fitted model with class \code{nauf.glm} (inheriting from \code{lm},
  and also possibly \code{glm} and/or \code{negbin} depending on the
  regression).  For the elements contained in the object, and additional
  class attributes the model may contain, see \code{\link[stats]{lm}},
  \code{\link[stats]{glm}}, and \code{\link[MASS]{glm.nb}}.
}
\description{
The fixed effects regression functions \code{nauf_lm}, \code{nauf_glm.nb},
and \code{nauf_glm} fit linear, negative binomial, and other generalized
linear models, respectively, impelementing \code{\link{nauf_contrasts}}.
}
\details{
\code{nauf_lm} is based on \code{\link[stats]{lm}} in the
\code{stats} package, \code{nauf_glm} on \code{\link[stats]{glm}} in the
\code{stats} package, and \code{nauf_glm.nb} on \code{\link[MASS]{glm.nb}} in
the \code{MASS} package; but implementing \code{\link{nauf_contrasts}}.  The
\code{nauf} functions have all the same arguments as the functions they are
based on, but additionally \code{ncs_scale}, which is passed to
\code{\link{nauf_model.frame}}.  Other than \code{ncs_scale}, the arguments
have the same functions as they do in the functions they are based on.  The
default values for \code{na.action}, \code{contrasts}, \code{model},
\code{x}, and \code{y} cannot be changed.  For \code{na.action} and
\code{contrasts}, see \code{\link{nauf_model.frame}}.  Forcing \code{model},
\code{x}, and \code{y} to be \code{TRUE} ensures that the fitted model
retains the model frame, model matrix, and response, respectively.  This is
necessary for some generic functions applied to the fitted model to work
properly.
}
\section{Note on Generics}{
 Methods for S3 generic functions from the
  \code{stats} and \code{MASS} packages should work for \code{nauf.glm}
  models as they normally would for the related regression models not fit
  with \code{\link{nauf_contrasts}}.  If you encounter a generic function in
  these packages which does not function properly, please report the issue at
  \url{https://github.com/CDEager/nauf/issues}.
}
\examples{
dat <- plosives
dat$spont[dat$dialect == "Valladolid"] <- NA
sdat <- standardize(intdiff ~ voicing * dialect * spont, dat)
mod <- nauf_lm(sdat$formula, sdat$data)

}
\seealso{
\code{\link{nauf_contrasts}} for a description of the contrasts
  applied to unordered factors; and \code{\link[stats]{lm}},
  \code{\link[stats]{glm}}, and \code{\link[MASS]{glm.nb}} for argument
  definitions.
}

