% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nauf_trms_fr_x_z.R
\name{nauf_model.frame}
\alias{nauf_model.frame}
\title{Create a model frame using \code{nauf} contrasts.}
\usage{
nauf_model.frame(formula, data = NULL, subset = NULL, na.action = na.pass,
  drop.unused.levels = TRUE, xlev = NULL, contrasts = NULL,
  ncs_scale = attr(formula, "standardized.scale"), ...)
}
\arguments{
\item{formula, data, subset, ...}{See \code{\link[stats]{model.frame}}.}

\item{na.action, drop.unused.levels, xlev, contrasts}{Changes from default
values for these arguments are ignored with a warning.}

\item{ncs_scale}{A positive number passed as the \code{scale} argument to
\code{\link[standardize]{named_contr_sum}} for all unordered factor
contrasts.  The default is to first check whether \code{formula} comes from
a \code{standardized} object returned by
\code{\link[standardize]{standardize}}. If it is, then the \code{scale}
argument from the \code{\link[standardize]{standardize}} call is used.  If
it is not, then \code{ncs_scale} is set to \code{1}.  The value for
\code{ncs_scale} can also be set explicitly.  If it is set explicitly and
\code{formula} is from a \code{standardized} object with a different scale
than the explicitly set value, then the explicitly set value
is used and a warning is issued.}
}
\value{
A model frame with second class attribute \code{nauf.frame}.  Its
  \code{formula} attribute has class \code{nauf.formula} and its \code{terms}
  attribute has class \code{\link{nauf.terms}}.
}
\description{
\code{nauf_model.frame} creates a model frame which employs
\code{\link{nauf_contrasts}} for unordered factors.
}
\details{
First, the default method for \code{\link[stats]{model.frame}} is called.
Then any variable in the resulting model frame that is not an unordered
factor but has only two unique non-\code{NA} values is coerced to an
unordered factor.  Unordered factors are then assigned contrasts with
\code{\link[standardize]{named_contr_sum}}, passing \code{ncs_scale} as the
function's \code{scale} argument.  Then, necessary contrast changes in
interaction terms and random effects slopes are determined as described in
\code{\link{nauf_contrasts}}.

The recommended usage is to first \code{\link[standardize]{standardize}} the
regression variables, and then use the \code{formula} and \code{data}
elements in the resulting \code{standardized} object as arguments to
\code{nauf_model.frame}.  When this is done, \code{ncs_scale} is obtained
from the \code{standardized.scale} attribute of the \code{formula}, unless
\code{ncs_scale} is specified as a value which does not match the
\code{standardized} scale, in which case the explicitly specified
\code{ncs_scale} argument is used with a warning.  If
\code{\link[standardize]{standardize}} is not used prior to calling
\code{nauf_model.frame}, then \code{ncs_scale} defaults to \code{1} unless
explicitly specified in the function call, in which case the specified value
is used.

Changes from the following default values are ignored with a warning:
\describe{
  \item{na.action = na.pass}{This default value is required in order for
    \code{NA} values to be treated as defined in
    \code{\link{nauf_contrasts}}.}
  \item{drop.unused.levels = TRUE}{This default value is set because
    \code{nauf_model.frame} assumes that \code{data} is not new data.  To
    create a \code{nauf.frame} with new data, the \code{terms}
    attribute of an already existing \code{nauf.frame} (which
    has class \code{\link{nauf.terms}}) can be used as the
    \code{formula} argument to \code{\link[stats]{model.frame}}.}
  \item{xlev = NULL}{This default is necessary for the same reasons as the
    default value for \code{drop.unused.levels}.}
  \item{contrasts = NULL}{For unordered factors, contrasts are automatically
    created with \code{\link[standardize]{named_contr_sum}}, as sum contrasts
    are necessary to implement \code{\link{nauf_contrasts}}.  To specify
    custom contrasts for ordered factors, the custom contrasts should be
    explicitly assigned to the ordered factor in \code{data} (this is
    automatically done if \code{\link[standardize]{standardize}} is used
    first as recommended).}
}
}
\examples{
dat <- plosives
dat$spont[dat$dialect == "Valladolid"] <- NA
form <- intdiff ~ voicing * dialect * spont +
  (1 + voicing * spont | speaker) + (1 + dialect | item)

## default behavior when standardize is not used
# defaults to ncs_scale = 1
mf <- nauf_model.frame(form, dat)

# uses specified ncs_scale = 0.5
mf_0.5 <- nauf_model.frame(form, dat, ncs_scale = 0.5)

## standardize first (recommended use)
sobj <- standardize(form, dat)
sobj_0.5 <- standardize(form, dat, scale = 0.5)

# uses ncs_scale = 1 from attr(sobj$formula, "standardized.scale")
mf_sobj <- nauf_model.frame(sobj$formula, sobj$data)

# uses ncs_scale = 0.5 from attr(sobj_0.5$formula, "standardized.scale")
mf_sobj_0.5 <- nauf_model.frame(sobj_0.5$formula, sobj_0.5$data)

\dontrun{
## not recommended
# uses specified ncs_scale = 0.5 and issues a warning since
# attr(sobj$formula, "standardized.scale") = 1
mf_warning <- nauf_model.frame(sobj$formula, sobj$data, ncs_scale = 0.5)
}

}
\seealso{
\code{\link{nauf_contrasts}} for a description of the contrasts
  applied to unordered factors, \code{\link{nauf_model.matrix}} for obtaining
  a fixed effects model matrix, and \code{\link{nauf_glFormula}} for
  obtaining both fixed effects and random effects model matrices.
}

