% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_season_stats.R
\name{team_season_stats}
\alias{team_season_stats}
\title{Extract teams statistics for season statistics from 2020-2024}
\usage{
team_season_stats(team = NULL, opponent = FALSE, sport = "WVB")
}
\arguments{
\item{team}{Name of school. Must match name used by NCAA. Find exact team
name with \code{\link[=find_team_name]{find_team_name()}}.}

\item{opponent}{Logical indicating whether to include team's stats
(FALSE) or opponent's stats (TRUE). Default is set to FALSE, returning
team stats.}

\item{sport}{Three letter abbreviation for NCAA sport (must be upper case;
for example "WVB" for women's volleyball and "MVB" for men's volleyball).}
}
\value{
Returns a data frame of summary team statistics for each season.
}
\description{
The NCAA's main page for a team includes a tab called "Game By Game"
and a section called "Career Totals". This function extracts season summary
stats.
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.

Due to changes in the NCAA website, statistics from before 2020 are no
longer available.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
team_season_stats(team = "Nebraska")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions that extract team statistics: 
\code{\link{team_match_stats}()},
\code{\link{team_season_info}()}
}
\concept{functions that extract team statistics}
