% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{plot.cv.ncpen}
\alias{plot.cv.ncpen}
\title{Plot cv curve from a \code{cv.ncpen} object}
\usage{
\method{plot}{cv.ncpen}(x, type = c("error", "deviance"), log.scale = FALSE,
  ...)
}
\arguments{
\item{x}{fitted \code{cv.ncpen} object.}

\item{type}{(character) a cross-validated error type which is either "error" or "deviance". Each error type is defined in \code{\link{cv.ncpen}}.}

\item{log.scale}{(logical) log scale of horizontal axis (a sequence of lambda values). Default value is FALSE.}

\item{...}{other graphical parameters to \code{plot}.}
}
\description{
Produces a plot of the cross-validated error curve from a fitted \code{cv.ncpen} object.
}
\examples{

s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5,family="binomial")
x.mat = s0$x.mat
y.vec = s0$y.vec

cvfit = cv.ncpen(y.vec=y.vec, x.mat=x.mat, family="binomial")
plot.cv.ncpen(cvfit, type="deviance")

}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO. \emph{Computational Statistics and Data Analysis}, \bold{92C}, 53-67.
}
\seealso{
\code{\link{cv.ncpen}}, \code{\link{coef.cv.ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee

Maintainer: Dongshin Kim<dongshin.kim@outlook.com>, Sunghoon Kwon<shkwon0522@gmail.com>
}
