% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neatmap.R
\name{neatmap}
\alias{neatmap}
\title{Heatmap of Networks}
\usage{
neatmap(df, scale.df, link.method = "average", dist.method = "euclidean",
  nBootRep = 1000, mainTitle = "", xlabel, ylabel, xlabCex = 5,
  ylabCex = 5, heatmapMargins = c(50, 50, 50, 100))
}
\arguments{
\item{df}{a dataframe of network attributes containing only
numeric values}

\item{scale.df}{A string indicating whether the data frame should be scaled, and if so,
which method should be used. The options are "none", "basic", "normalize" and "percentize".
If "none" is selected, then no scaling takes place.  If "basic" is selected, each
column is reduced to the 0-1 interval, whithout changing the underlying distribution. 
If "normalize" is selected, each column is normalized to have a mean of 0 and 
standard deviation of 1. If "percentize" is selected, column values are transformed 
into percentiles. This conserves the underlying distribution of the data if the data
is not expected to be normally distributed.}

\item{link.method}{The agglomeration method to be used. See method in \link{hclust}.}

\item{dist.method}{The distance measure to be used. See method in \link{dist}.}

\item{nBootRep}{The number of bootstrap replications for the statistical analysis of 
the hierarchical clustering. See \link{pvclust}.}

\item{mainTitle}{The title of the heatmap.}

\item{xlabel}{The x axis label of the heatmap.}

\item{ylabel}{The y axis label of the heatmap.}

\item{xlabCex}{The font size of the elements on the x axis.}

\item{ylabCex}{The font size of the elements on the y axis.}

\item{heatmapMargins}{The size of the margins for the heatmap. See \link{heatmaply}.}
}
\value{
A list containing the dendrogram of the hierarchical clustering,
  the significant clusters of the statistical analysis, the results of
  the statistical analysis and the heatmap.
}
\description{
\code{neatmap} produces a heatmap of networks and their characteristics
}
\details{
This function generates a heatmap of networks and their various
characteristics from a data frame containing only numeric variables. These
numeric values are then scaled using a chosen method. The hierarchical
cluster analysis results used in the heatmap are also output. The 
heatmap is produced using the \link{heatmaply} package.
}
\examples{
df <- netsDataFrame(net.attr.df = networkAttrDF,
                    node.attr.df = nodeAttrDF,
                    edge.df = edgeDF)
heatmap <- neatmap(df, scale.df = "basic", mainTitle = "Heatmap", 
                   xlabel = "Chararacteritics", ylabel = "Networks",
                   link.method = "single", dist.method = "euclidean",
                   nBootRep = 10)

}
\author{
Phil Boileau , \email{philippe.boileau@mail.concordia.ca}
}
