% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTaxonList.R
\name{getTaxonList}
\alias{getTaxonList}
\title{Get NEON taxon table}
\usage{
getTaxonList(
  taxonType = NA,
  recordReturnLimit = NA,
  stream = "true",
  verbose = "false",
  token = NA
)
}
\arguments{
\item{taxonType}{The taxonTypeCode to access. Must be one of ALGAE, BEETLE, BIRD, FISH, HERPETOLOGY, MACROINVERTEBRATE, MOSQUITO, MOSQUITO_PATHOGENS, SMALL_MAMMAL, PLANT, TICK [character]}

\item{recordReturnLimit}{The number of items to limit the result set to. If NA (the default), will return either the first 100 records, or all records in the table, depending on the value of `stream`. Use `stream='true'` to get all records. [integer]}

\item{stream}{True or false, obtain the results as a stream. Utilize for large requests. Note this is lowercase true and false as character strings, not logical. [character]}

\item{verbose}{True or false, include all possible taxonomic parameters. Defaults to false, only essential parameters. Note this is lowercase true and false as character strings, not logical. [character]}

\item{token}{User specific API token (generated within neon.datascience.org user account) [character]}
}
\value{
Data frame with selected NEON taxonomic data
}
\description{
This is a function to retrieve a taxon table from the NEON data portal for a given taxon type and provide it in a tractable format.
}
\examples{
# taxonTypeCode must be one of	
# ALGAE, BEETLE, BIRD, FISH,	
# HERPETOLOGY, MACROINVERTEBRATE, 
# MOSQUITO, MOSQUITO_PATHOGENS,	
# SMALL_MAMMAL, PLANT, TICK	
#################################	
# get the first 4 fish taxa	
taxa_table <- getTaxonList('FISH', recordReturnLimit = 4)

}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Eric R. Sokol \email{esokol@battelleecology.org}
}
