% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{models}
\alias{models}
\alias{models.nestedLogit}
\title{Extract Binary Logit Models from a \code{nestedLogit} Object}
\usage{
models(model, select, as.list = FALSE)

\method{models}{nestedLogit}(model, select, as.list = FALSE)
}
\arguments{
\item{model}{a \code{"nestedLogit"} model.}

\item{select}{a numeric or character vector giving the number(s) or names(s)
of one or more
binary logit models to be extracted from \code{model}; if absent, a list of
all of the binary logits models in \code{model} is returned.}

\item{as.list}{if \code{TRUE} (the default is \code{FALSE}) and one binary logit
model is selected, return the \code{"glm"} object in a one-element named list;
otherwise a single model is returned directly as a \code{"glm"} object;
when more than one binary
logit model is selected, the corresponding \code{"glm"} objects are \emph{always}
returned as a named list.}
}
\value{
\code{model} returns either a single \code{"glm"} object (see \code{\link{glm}}) or a
list of \code{"glm"} objects, each representing a binary logit model.
}
\description{
\code{models} is used to extract \code{"glm"} objects representing binary logit
models from a \code{"nestedLogit"} object.
}
\examples{
  data(Womenlf, package = "carData")

  comparisons <- logits(work=dichotomy("not.work",
                                       working=c("parttime", "fulltime")),
                        full=dichotomy("parttime", "fulltime"))
  m <- nestedLogit(partic ~ hincome + children,
                   dichotomies = comparisons,
                   data=Womenlf)

  # extract a binomial logit model
  models(m, "work")
  # use that to plot residuals
  plot(density(residuals(models(m, "work"))))
}
