% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nested.R
\name{plot.nestedLogit}
\alias{plot.nestedLogit}
\title{Plotting Nested Logit Models}
\usage{
\method{plot}{nestedLogit}(
  x,
  x.var,
  others,
  n.x.values = 100L,
  xlab = x.var,
  ylab = "Fitted Probability",
  main,
  cex.main = 1,
  font.main = 1L,
  pch = 1L:length(response.levels),
  lwd = 3,
  lty = 1L:length(response.levels),
  col = palette()[1L:length(response.levels)],
  legend = TRUE,
  legend.inset = 0.01,
  legend.location = "topleft",
  legend.bty = "n",
  ...
)
}
\arguments{
\item{x}{an object of \code{"nestedLogit"} produced by \code{\link{nestedLogit}}.}

\item{x.var}{quoted name of the variable to appear on the x-axis; if omitted, the first
predictor in the model is used.}

\item{others}{a named list of values for the other variables in the model,
that is, other than \code{x.var}; if any other predictor is omitted, it is set
to an arbitrary value---the mean for a numeric predictor or the first level or
value of a factor, character, or logical predictor; only one value may be
specified for each variable in \code{others}.}

\item{n.x.values}{the number of evenly spaced values of \code{x.var} at which
to evaluate fitted probabilities to be plotted (default \code{100}).}

\item{xlab}{label for the x-axis (defaults to the value of \code{x.var}).}

\item{ylab}{label for the y-axis (defaults to \code{"Fitted Probability"}).}

\item{main}{main title for the graph (if missing, constructed from the variables and
values in \code{others}).}

\item{cex.main}{size of main title (see \code{\link{par}}).}

\item{font.main}{font for main title (see \code{\link{par}}).}

\item{pch}{plotting characters (see \code{\link{par}}).}

\item{lwd}{line width (see \code{\link{par}}).}

\item{lty}{line types (see \code{\link{par}}).}

\item{col}{line colors (see \code{\link{par}}).}

\item{legend}{if \code{TRUE} (the default), add a legend for the
response levels to the graph.}

\item{legend.inset}{default \code{0.01} (see \code{\link{legend}}).}

\item{legend.location}{position of the legend (default \code{"topleft"},
see \code{\link{legend}}).}

\item{legend.bty}{the type of box to be drawn around the legend. The allowed values are "o" (the default) and "n".}

\item{\dots}{arguments to be passed to \code{\link{matplot}}.}
}
\value{
NULL Used for its side-effect of producing a plot
}
\description{
A \code{\link{plot}} method for \code{"nestedLogit"} objects produced by the
\code{\link{nestedLogit}} function. Fitted probabilities under the model are plotted
for each level of the polytomous response variable, with one of the explanatory variables
on the horizontal axis and other explanatory variables fixed to particular values.
}
\examples{
data(Womenlf, package = "carData")
m <- nestedLogit(partic ~ hincome + children,
                 logits(work=dichotomy("not.work", c("parttime", "fulltime")),
                        full=dichotomy("parttime", "fulltime")),
                        data=Womenlf)
plot(m, legend.location="top")
op <- par(mfcol=c(1, 2), mar=c(4, 4, 3, 1) + 0.1)
plot(m, "hincome", list(children="absent"),
     xlab="Husband's Income", legend=FALSE)
plot(m, "hincome", list(children="present"),
     xlab="Husband's Income")
par(op)
}
\seealso{
\code{\link{nestedLogit}}, \code{\link[graphics]{matplot}}
}
\author{
John Fox \email{jfox@mcmaster.ca}
}
