% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/nestedRanksTest.R
\name{print.htest_boot}
\alias{print.htest_boot}
\title{Print result of \code{nestedRanksTest}.}
\usage{
\method{print}{htest_boot}(x, ...)
}
\arguments{
\item{x}{Value of class \code{'htest_boot'} as returned by
\code{nestedRanksTest}.}

\item{\dots}{Additional arguments passed to \code{print.htest}.}
}
\value{
The value of x is returned invisibly.
}
\description{
\code{print.htest_boot} prints the return value of
\code{\link{nestedRanksTest}}, a list of class \code{'htest_boot'}
which extends class \code{'htest'} by including group weights, the
number of bootstrap iterations, and the complete null distribution.
The latter is not printed by this function; it may be visualised with
\code{\link{plot.htest_boot}}.
}
\examples{
data(woodpecker_multiyear)
## n.iter set to 1000 to shorten completion time
res <- nestedRanksTest(Distance ~ Year | Granary, n.iter = 1000,
                       data = woodpecker_multiyear,
                       subset = Species == "agrifolia")
class(res)
print(res)
}
\seealso{
\code{\link{nestedRanksTest}} for the test description,
  \code{\link{plot.htest_boot}} for a graphical plot of test
  results, and \code{\link{print.htest}} for the print method of
  the base class.
}

