% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{correls2}
\alias{correls2}
\title{Correlation between a vector and a matrix}
\usage{
correls2(y, x, method = "pearson", use = "complete.obs")
}
\arguments{
\item{y}{Numerical vector}

\item{x}{Matrix}

\item{method}{Type of correlation, either "pearson" or "spearman".}

\item{use}{Optional character string giving a method for computing
covariances in the presence of missing values. See \link{cor}}
}
\value{
Matrix with columns containing the correlation statistic, either
Pearson r or Spearman rho, and p-values for each column of \code{x} correlated
against vector \code{y}
}
\description{
Fast Pearson/Spearman correlation where \code{y} is vector, \code{x} is matrix, adapted
from \link[stats:cor.test]{stats::cor.test}.
}
\details{
For speed, p-values for Spearman's test are computed by
asymptotic t approximation, equivalent to \link{cor.test} with \code{exact = FALSE}.
}
