% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVfeature.R
\docType{data}
\name{IVfeature}
\alias{IVfeature}
\title{IV features data}
\format{A data frame with 20 rows and 9 variables:
\describe{
  \item{Pmp}{max power at the measurement step}
  \item{dy}{the exposure time after been converted into decimal year}
  \item{Isc}{short circuit current}
  \item{Imp}{current at max power}
  \item{Rs}{series resistance}
  \item{Voc}{open circuit voltage}
}}
\source{
Solar Durability and Lifetime Extension (SDLE) Research Center, Case Western
Reserve University
}
\usage{
data(IVfeature)
}
\description{
The dataset is current-voltage(I-V) features data obtained by I-V features extracted 
algorithm for the brand A modules under damp heat indoor accelerated test which is up 
to 3000 hours. The measurement were taken every 500h. The raw data is provided by 
SunEdison company. 
The I-V features include max power(Pmp), short circuit current(Isc), current at max 
power(Imp), fill factor(FF), series resistance(Rs), shunt resistance(Rsh), open circuit 
voltage(Voc), voltage at max power(Vmp). Rsh is too noisy to contain for modeling. 
After checking the correlation between Isc, Imp, Voc, Vmp, FF, Rs. FF, Rs, Vmp are 
highly correlated, so we randomly select one to be contained in the model. Here we 
choose Isc, Imp, Rs and Voc to be contained in the model and these four I-V features 
show no indication of high correlation. The trend of the I-V features are related 
with the mechanims of PV degradation. The variable 'dy' is time that has been 
converted into decimal year in which 1 means 1 year.
We would use this dataet to buit <S|M|R> model with time as stressor, four I-V 
features as mechanisms and max power as reponse.
}
\author{
Jiqi Liu, Alan Curran, Justin S. Fada, Xuan Ma, Wei-Heng Huang, Jennifer L. Braid, Roger H. French
}
\keyword{datasets}
