% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfr_benchmark.R
\name{sample_lfr}
\alias{sample_lfr}
\title{LFR benchmark graphs}
\usage{
sample_lfr(
  n,
  tau1,
  tau2,
  mu,
  average_degree = NULL,
  min_degree = NULL,
  max_degree = NULL,
  min_community = NULL,
  max_community = NULL,
  tol = 1e-07,
  max_iters = 500
)
}
\arguments{
\item{n}{Number of nodes in the created graph.}

\item{tau1}{Power law exponent for the degree distribution of the created graph. This value must be strictly greater than one}

\item{tau2}{Power law exponent for the community size distribution in the created graph. This value must be strictly greater than one}

\item{mu}{Fraction of inter-community edges incident to each node. This value must be in the interval 0 to 1.}

\item{average_degree}{Desired average degree of nodes in the created graph. This value must be in the interval 0 to n. Exactly one of this and \code{min_degree} must be specified, otherwise an error is raised}

\item{min_degree}{Minimum degree of nodes in the created graph. This value must be in the interval 0 to n. Exactly one of this and \code{average_degree} must be specified, otherwise an error is raised.}

\item{max_degree}{Maximum degree of nodes in the created graph. If not specified, this is set to n-1.}

\item{min_community}{Minimum size of communities in the graph. If not specified, this is set to \code{min_degree}}

\item{max_community}{Maximum size of communities in the graph. If not specified, this is set to n, the total number of nodes in the graph.}

\item{tol}{Tolerance when comparing floats, specifically when comparing average degree values.}

\item{max_iters}{Maximum number of iterations to try to create the community sizes, degree distribution, and community affiliations.}
}
\value{
an igraph object
}
\description{
Generates benchmark networks for clustering tasks with a priori known communities. The algorithm accounts for the heterogeneity in the distributions of node degrees and of community sizes.
}
\details{
code adapted from the implementation in NetworkX: https://networkx.org/documentation/stable/_modules/networkx/generators/community.html#LFR_benchmark_graph
}
\references{
A. Lancichinetti, S. Fortunato, and F. Radicchi.(2008) Benchmark graphs for testing community detection algorithms. Physical Review E, 78. arXiv:0805.4770
}
\author{
David Schoch
}
