% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bass.r
\name{bass}
\alias{bass}
\alias{fitbass}
\alias{fitbass.diffnet}
\alias{fitbass.default}
\alias{plot.diffnet_bass}
\alias{bass_F}
\alias{bass_dF}
\alias{bass_f}
\title{Bass Model}
\usage{
fitbass(dat, ...)

\method{fitbass}{diffnet}(dat, ...)

\method{fitbass}{default}(dat, ...)

\method{plot}{diffnet_bass}(
  x,
  y = 1:length(x$m$lhs()),
  add = FALSE,
  pch = c(21, 24),
  main = "Bass Diffusion Model",
  ylab = "Proportion of adopters",
  xlab = "Time",
  type = c("b", "b"),
  lty = c(2, 1),
  col = c("black", "black"),
  bg = c("lightblue", "gray"),
  include.legend = TRUE,
  ...
)

bass_F(Time, p, q)

bass_dF(p, q, Time)

bass_f(Time, p, q)
}
\arguments{
\item{dat}{Either a diffnet object, or a numeric vector.
Observed cumulative proportion of adopters.}

\item{...}{Further arguments passed to the method.}

\item{x}{An object of class \code{diffnet_bass}.}

\item{y}{Integer vector. Time (label).}

\item{add}{Passed to \code{\link[graphics:plot]{matplot}}.}

\item{pch}{Passed to \code{\link[graphics:plot]{matplot}}.}

\item{main}{Passed to \code{\link[graphics:plot]{matplot}}.}

\item{ylab}{Character scalar. Label of the \code{y} axis.}

\item{xlab}{Character scalar. Label of the \code{x} axis.}

\item{type}{Passed to \code{\link[graphics:plot]{matplot}}.}

\item{lty}{Passed to \code{\link[graphics:plot]{matplot}}.}

\item{col}{Passed to \code{\link[graphics:plot]{matplot}}.}

\item{bg}{Passed to \code{\link[graphics:plot]{matplot}}.}

\item{include.legend}{Logical scalar. When \code{TRUE}, draws a legend.}

\item{Time}{Integer vector with values greater than 0. The \eqn{t} parameter.}

\item{p}{Numeric scalar. Coefficient of innovation.}

\item{q}{Numeric scalar. Coefficient of imitation.}
}
\value{
An object of class \code{nls} and \code{diffnet_bass}. For more
details, see \code{\link[stats:nls]{nls}} in the \pkg{stats} package.
}
\description{
Fits the Bass Diffusion model. In particular, fits an observed curve of
proportions of adopters to \eqn{F(t)}, the proportion of adopters at time
\eqn{t}, finding the corresponding coefficients \eqn{p}, Innovation rate,
and \eqn{q}, imitation rate.
}
\details{
The function fits the bass model with parameters \eqn{[p, q]} for
values \eqn{t = 1, 2, \dots, T}, in particular, it fits the following function:

\deqn{
  F(t) = \frac{1 - \exp{-(p+q)t}}{1 + \frac{q}{p}\exp{-(p+q)t}}
}{
  F(t) = [1 - exp(-(p + q)*t)]/[1 + exp(-(p + q)*t)*(q/p)]
}

Which is implemented in the \code{bass_F} function. The proportion of adopters
at time \eqn{t}, \eqn{f(t)} is:

\deqn{
  f(t) = \left\{\begin{array}{ll}
  F(t), & t = 1 \\
  F(t) - F(t-1), & t > 1
  \end{array}\right.
}{
  f(t) = ifelse(t == 1, F(t), F(t) - F(t-1))
}

and it's implemented in the \code{bass_f} function.

For testing purposes only, the gradient of \eqn{F} with respect to \eqn{p}
and \eqn{q} is implemented in \code{bass_dF}.

The estimation is done using \code{\link[stats:nls]{nls}}.
}
\examples{
# Fitting the model for the Brazilian Farmers Data --------------------------
data(brfarmersDiffNet)
ans <- fitbass(brfarmersDiffNet)

# All the methods that work for the -nls- object work here
ans
summary(ans)
coef(ans)
vcov(ans)

# And the plot method returns both, fitted and observed curve
plot(ans)

}
\references{
Bass's Basement Institute Institute. The Bass Model. (2010).
Available at: \url{https://web.archive.org/web/20220331222618/http://www.bassbasement.org/BassModel/}.
(accessed live for the last time on March 29th, 2017.)
}
\seealso{
Other statistics: 
\code{\link{classify_adopters}()},
\code{\link{cumulative_adopt_count}()},
\code{\link{dgr}()},
\code{\link{ego_variance}()},
\code{\link{exposure}()},
\code{\link{hazard_rate}()},
\code{\link{infection}()},
\code{\link{moran}()},
\code{\link{struct_equiv}()},
\code{\link{threshold}()},
\code{\link{vertex_covariate_dist}()}
}
\author{
George G. Vega Yon
}
\concept{statistics}
