% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnel.netmeta.R
\name{funnel.netmeta}
\alias{funnel.netmeta}
\title{\sQuote{Comparison-adjusted} funnel plot}
\usage{
\method{funnel}{netmeta}(
  x,
  order,
  pooled = ifelse(x$random, "random", "common"),
  xlab = NULL,
  level = x$level,
  pch,
  col = "black",
  legend = TRUE,
  pos.legend = "topright",
  pos.tests = "topleft",
  lump.comparator = FALSE,
  text.comparator = "comparator",
  method.bias,
  text.linreg = "(Egger)",
  text.rank = "(Begg-Mazumdar)",
  text.mm = "(Thompson-Sharp)",
  sep.trts = x$sep.trts,
  nchar.trts = x$nchar.trts,
  backtransf = x$backtransf,
  digits.pval = gs("digits.pval"),
  warn.deprecated = gs("warn.deprecated"),
  linreg = FALSE,
  rank = FALSE,
  mm = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{order}{A mandatory character or numerical vector specifying
the order of treatments or list of comparators (see Details).}

\item{pooled}{A character string indicating whether results for the
common (\code{"common"}) or random effects model (\code{"random"})
should be plotted. Can be abbreviated.}

\item{xlab}{A label for the x-axis.}

\item{level}{The confidence level utilised in the plot. For the
funnel plot, confidence limits are not drawn if \code{yaxis =
"size"}.}

\item{pch}{The plotting symbol(s) used for individual studies
within direct comparisons.}

\item{col}{The colour(s) used for individual studies within direct
comparisons.}

\item{legend}{A logical indicating whether a legend with
information on direct comparisons should be added to the plot.}

\item{pos.legend}{The position of the legend describing plotting
symbols and colours for direct comparisons.}

\item{pos.tests}{The position of results for test(s) of funnel plot
asymmetry.}

\item{lump.comparator}{A logical indicating whether comparators
should be lumped, e.g., to specify inactive treatments.
information on direct comparisons should be added to the plot.}

\item{text.comparator}{A character string used in the plot to label
the comparator if \code{lump.comparator} is \code{TRUE}.}

\item{method.bias}{A character vector indicating which test(s) for
funnel plot asymmetry to use. Admissible values are
\code{"Begg"}, \code{"Egger"}, and \code{"Thompson"}, can be
abbreviated. See function \code{\link[meta]{metabias}}.}

\item{text.linreg}{A character string used in the plot to label the
Egger test for funnel plot asymmetry.}

\item{text.rank}{A character string used in the plot to label the
Begg test for funnel plot asymmetry.}

\item{text.mm}{A character string used in the plot to label the
Thompson-Sharp test for funnel plot asymmetry.}

\item{sep.trts}{A character used in comparison names as separator
between treatment labels.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names (see
\code{\link{netmeta}}).}

\item{backtransf}{A logical indicating whether results for relative
summary measures (argument \code{sm} equal to \code{"OR"},
\code{"RR"}, \code{"HR"}, or \code{"IRR"}) should be back
transformed in funnel plots. If \code{backtransf = TRUE}, results
for \code{sm = "OR"} are printed as odds ratios rather than log
odds ratios, for example.}

\item{digits.pval}{Minimal number of significant digits for p-value
of test(s) for funnel plot asymmetry.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{linreg}{Deprecated argument (replaced by \code{method.bias}).}

\item{rank}{Deprecated argument (replaced by \code{method.bias}).}

\item{mm}{Deprecated argument (replaced by \code{method.bias}).}

\item{\dots}{Additional graphical arguments passed as arguments to
\code{\link{funnel.meta}}.}
}
\value{
A data frame with the following columns:
\item{studlab}{Study label.}
\item{treat1}{Label/Number for first treatment.}
\item{treat2}{Label/Number for second treatment.}
\item{comparison}{Treatment comparison.}
\item{TE}{Estimate of treatment effect, e.g., log odds ratio.}
\item{TE.direct}{Pooled estimate from direct evidence.}
\item{TE.adj}{\sQuote{Comparison-adjusted} treatment effect (TE -
  TE.direct).}
\item{seTE}{Standard error of treatment estimate.}
\item{pch}{Plotting symbol(s).}
\item{col}{Colour of plotting symbol(s).}
}
\description{
Draw a \sQuote{comparison-adjusted} funnel plot to assess funnel
plot asymmetry in network meta-analysis.
}
\details{
A \sQuote{comparison-adjusted} funnel plot (Chaimani & Salanti,
2012) is drawn in the active graphics window.

Argument \code{order} is mandatory to determine the order of
treatments (Chaimani et al., 2013):

\emph{\dQuote{Before using this plot, investigators should order
the treatments in a meaningful way and make assumptions about how
small studies differ from large ones. For example, if they
anticipate that newer treatments are favored in small trials, then
they could name the treatments from oldest to newest so that all
comparisons refer to \sQuote{old versus new intervention}. Other
possibilities include defining the comparisons so that all refer to
an active treatment versus placebo or sponsored versus
non-sponsored intervention.}}

Alternatively, it is possible to only provide a single or few
treatment name(s) in argument \code{order} to define the
comparator(s). In this case only comparisons with this / these
treatment(s) will be considered. If argument \code{lump.comparator}
is \code{TRUE}, all comparators will be lumped into a single
group. The text for this group can be specified with argument
\code{text.comparator}.

In the funnel plot, if \code{yaxis} is \code{"se"}, the standard
error of the treatment estimates is plotted on the y-axis which is
likely to be the best choice (Sterne & Egger, 2001). Other possible
choices for \code{yaxis} are \code{"invvar"} (inverse of the
variance), \code{"invse"} (inverse of the standard error), and
\code{"size"} (study size).
}
\examples{
\dontrun{
data(Senn2013)

net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD")

# 'Comparison-adjusted' funnel plot not created as argument 'order'
# is missing
#
try(funnel(net1))

# Only show comparisons with placebo
#
funnel(net1, order = "pl")

# Add result for Egger test of funnel plot asymmetry
#
funnel(net1, order = "pl", method.bias = "Egger",
  digits.pval = 2)

# (Non-sensical) alphabetic order of treatments with placebo as
# last treatment
#
ord <- c("a", "b", "me", "mi", "pi", "r", "si", "su", "v", "pl")
funnel(net1, order = ord)

# Add results for tests of funnel plot asymmetry and use different
# plotting symbols and colours
#
funnel(net1, order = ord,
  pch = rep(c(15:18, 1), 3), col = 1:3,
  method.bias = c("Egger", "Begg", "Thompson"), digits.pval = 2)

# Same results for tests of funnel plot asymmetry using reversed
# order of treatments
#
funnel(net1, order = rev(ord),
  pch = rep(c(15:18, 1), 3), col = 1:3,
  method.bias = c("Egger", "Begg", "Thompson"), digits.pval = 2)

# Calculate tests for funnel plot asymmetry
#
f1 <- funnel(net1, order = ord)
#
metabias(metagen(TE.adj, seTE, data = f1))
metabias(metagen(TE.adj, seTE, data = f1), method = "Begg")
metabias(metagen(TE.adj, seTE, data = f1), method = "Thompson")
}

}
\references{
Chaimani A & Salanti G (2012):
Using network meta-analysis to evaluate the existence of
small-study effects in a network of interventions.
\emph{Research Synthesis Methods},
\bold{3}, 161--76

Chaimani A, Higgins JP, Mavridis D, Spyridonos P, Salanti G (2013):
Graphical tools for network meta-analysis in STATA.
PLOS ONE,
\bold{8}, e76654

Sterne JAC & Egger M (2001):
Funnel plots for detecting bias in meta-analysis: Guidelines on
choice of axis.
\emph{Journal of Clinical Epidemiology},
\bold{54}, 1046--55
}
\seealso{
\code{\link{netmeta}}, \code{\link{funnel.meta}},
  \code{\link{metabias}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{hplot}
