% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_netmhc2pan_data_from_file.R
\name{install_netmhc2pan_data_from_file}
\alias{install_netmhc2pan_data_from_file}
\title{Install the NetMHCIIpan data from file}
\usage{
install_netmhc2pan_data_from_file(
  netmhc2pan_data_tarfile_path,
  netmhc2pan_folder_name = rappdirs::user_data_dir(),
  verbose = FALSE
)
}
\arguments{
\item{netmhc2pan_data_tarfile_path}{path of the
NetMHCIIpan data tarball file}

\item{netmhc2pan_folder_name}{the folder (to be) used by NetMHCIIpan.
From this location, a subfolder for NetMHCIIpan is created.
Use \link{get_default_netmhc2pan_folder} to see the location
of the default NetMHCIIpan folder.
Use \link{get_default_netmhc2pan_subfolder} to see the location
of the default NetMHCIIpan subfolder.}

\item{verbose}{set to TRUE for more output}
}
\value{
Nothing
}
\description{
Install the NetMHCIIpan data from the NetMHCIIpan data tarball file
to the default NetMHCIIpan folder.
}
\details{
The NetMHCIIpan data tarball file can be in any path.

The data tarball file can be downloaded from
\url{https://www.cbs.dtu.dk/services/NetMHCIIpan-3.2/data.Linux.tar.gz},
without filling in a contact form.
}
\author{
Richèl J.C. Bilderbeek
}
